/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.rmi.context;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.instrumentation.rmi.context.client.RmiClientContextInstrumentation;
import io.opentelemetry.javaagent.instrumentation.rmi.context.server.RmiServerContextInstrumentation;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappingsBuilder;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;

@AutoService(value={InstrumentationModule.class})
public class RmiContextPropagationInstrumentationModule
extends InstrumentationModule
implements InstrumentationModuleMuzzle {
    public RmiContextPropagationInstrumentationModule() {
        super("rmi", new String[]{"rmi-context-propagation"});
    }

    public boolean isIndyModule() {
        return false;
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        return Arrays.asList(new RmiClientContextInstrumentation(), new RmiServerContextInstrumentation());
    }

    public Map getMuzzleReferences() {
        HashMap<String, ClassRef> hashMap = new HashMap<String, ClassRef>(7, 0.75f);
        hashMap.put("sun.rmi.transport.Target", ClassRef.builder((String)"sun.rmi.transport.Target").addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.RmiServerContextInstrumentation$ObjectTableAdvice", 51).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 38).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 38)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "<init>", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/rmi/Remote;"), Type.getType((String)"Lsun/rmi/server/Dispatcher;"), Type.getType((String)"Ljava/rmi/Remote;"), Type.getType((String)"Ljava/rmi/server/ObjID;"), Type.getType((String)"Z")}).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher").addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.RmiServerContextInstrumentation$ObjectTableAdvice", 51).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 0).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 38).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 34).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 35).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("java.lang.Object").addInterfaceName("sun.rmi.server.Dispatcher").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 38), new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 34)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "CONTEXT_DISPATCHER", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/rmi/context/server/ContextDispatcher;"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 38), new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 35)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "NOOP_REMOTE", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/rmi/context/server/ContextDispatcher$NoopRemote;"), true).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "dispatch", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/rmi/Remote;"), Type.getType((String)"Ljava/rmi/server/RemoteCall;")}).build());
        hashMap.put("sun.rmi.transport.Connection", ClassRef.builder((String)"sun.rmi.transport.Connection").addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 53).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 54).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 67).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 74).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 76).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.client.RmiClientContextInstrumentation$StreamRemoteCallConstructorAdvice", 97).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.client.RmiClientContextInstrumentation$StreamRemoteCallConstructorAdvice", 110).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.client.RmiClientContextInstrumentation$StreamRemoteCallConstructorAdvice", 113).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 76)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getOutputStream", Type.getType((String)"Ljava/io/OutputStream;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.client.RmiClientContextInstrumentation$StreamRemoteCallConstructorAdvice", 97)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isReusable", Type.getType((String)"Z"), new Type[0]).build());
        hashMap.put("sun.rmi.transport.StreamRemoteCall", ClassRef.builder((String)"sun.rmi.transport.StreamRemoteCall").addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 74).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 78).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 96).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 110).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 98).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 74)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "<init>", Type.getType((String)"V"), new Type[]{Type.getType((String)"Lsun/rmi/transport/Connection;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 78)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getOutputStream", Type.getType((String)"Ljava/io/ObjectOutput;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 96)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "executeCall", Type.getType((String)"V"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 110)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "done", Type.getType((String)"V"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator", 98)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServerException", Type.getType((String)"Ljava/lang/Exception;"), new Type[0]).build());
        hashMap.put("sun.rmi.server.Dispatcher", ClassRef.builder((String)"sun.rmi.server.Dispatcher").addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 0).addSource("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher", 38).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        return hashMap;
    }

    public List getMuzzleHelperClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(6);
        arrayList.add("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPayload");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.rmi.context.server.ContextDispatcher$NoopRemote");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPayload$ContextPayloadGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPayload$ContextPayloadSetter");
        return arrayList;
    }

    public void registerMuzzleVirtualFields(VirtualFieldMappingsBuilder virtualFieldMappingsBuilder) {
        virtualFieldMappingsBuilder.register("sun.rmi.transport.Connection", "java.lang.Boolean");
    }
}

