/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.rmi.context.client;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator;
import java.lang.instrument.Instrumentation;
import java.rmi.server.ObjID;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import sun.rmi.transport.Connection;

public class RmiClientContextInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"sun.rmi.transport.StreamRemoteCall");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"sun.rmi.transport.Connection"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"java.rmi.server.ObjID"))), this.getClass().getName() + "$StreamRemoteCallConstructorAdvice");
        transformer.applyTransformer((builder, typeDescription, classLoader, javaModule, protectionDomain) -> {
            if (JavaModule.isSupported() && classLoader == null && "sun.rmi.transport.StreamRemoteCall".equals(typeDescription.getName()) && javaModule != null) {
                Instrumentation instrumentation = InstrumentationHolder.getInstrumentation();
                ClassInjector.UsingInstrumentation.redefineModule((Instrumentation)instrumentation, (JavaModule)javaModule, Collections.emptySet(), Collections.emptyMap(), Collections.singletonMap("sun.rmi.transport", Collections.singleton(JavaModule.ofType(AgentClassLoader.class))), Collections.emptySet(), Collections.emptyMap());
            }
            return builder;
        });
    }

    public static class StreamRemoteCallConstructorAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) Connection c, @Advice.Argument(value=1) ObjID id) {
            if (!c.isReusable()) {
                return;
            }
            if (ContextPropagator.PROPAGATOR.isRmiInternalObject(id)) {
                return;
            }
            Context currentContext = Java8BytecodeBridge.currentContext();
            Span activeSpan = Java8BytecodeBridge.spanFromContext((Context)currentContext);
            if (!activeSpan.getSpanContext().isValid()) {
                return;
            }
            VirtualField knownConnections = VirtualField.find(Connection.class, Boolean.class);
            ContextPropagator.PROPAGATOR.attemptToPropagateContext((VirtualField<Connection, Boolean>)knownConnections, c, currentContext);
        }
    }
}

