/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.rmi.context.jpms;

import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class ExposeRmiModuleInstrumentation
implements TypeInstrumentation {
    private static final Logger logger = Logger.getLogger(ExposeRmiModuleInstrumentation.class.getName());
    private final AtomicBoolean instrumented = new AtomicBoolean();

    public ElementMatcher<TypeDescription> typeMatcher() {
        ElementMatcher.Junction.AbstractBase<TypeDescription> notInstrumented = new ElementMatcher.Junction.AbstractBase<TypeDescription>(){

            public boolean matches(TypeDescription target) {
                return !ExposeRmiModuleInstrumentation.this.instrumented.get();
            }
        };
        return notInstrumented.and((ElementMatcher)ElementMatchers.nameStartsWith((String)"sun.rmi"));
    }

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return new ElementMatcher.Junction.AbstractBase<ClassLoader>(){

            public boolean matches(ClassLoader target) {
                return JavaModule.isSupported() && target == null;
            }
        };
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyTransformer((builder, typeDescription, classLoader, javaModule, protectionDomain) -> {
            if (javaModule != null && javaModule.isNamed()) {
                JavaModule helperModule = JavaModule.ofType(Java8BytecodeBridge.class);
                ClassInjector.UsingInstrumentation.redefineModule((Instrumentation)InstrumentationHolder.getInstrumentation(), (JavaModule)javaModule, Collections.emptySet(), Collections.singletonMap("sun.rmi.server", Collections.singleton(helperModule)), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
                this.instrumented.set(true);
                logger.log(Level.FINE, "Exposed package \"sun.rmi.server\" in module {0} to unnamed module", javaModule);
            }
            return builder;
        });
    }
}

