/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.rmi.context.server;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.bootstrap.rmi.ThreadLocalContext;
import io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPayload;
import io.opentelemetry.javaagent.instrumentation.rmi.context.ContextPropagator;
import java.io.IOException;
import java.io.ObjectInput;
import java.rmi.Remote;
import java.rmi.server.RemoteCall;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.Target;

public class ContextDispatcher
implements Dispatcher {
    private static final ContextDispatcher CONTEXT_DISPATCHER = new ContextDispatcher();
    private static final NoopRemote NOOP_REMOTE = new NoopRemote();

    public static Target newDispatcherTarget() {
        return new Target(NOOP_REMOTE, CONTEXT_DISPATCHER, NOOP_REMOTE, ContextPropagator.CONTEXT_CALL_ID, false);
    }

    @Override
    public void dispatch(Remote obj, RemoteCall call) throws IOException {
        ContextPayload payload;
        ObjectInput in = call.getInputStream();
        int operationId = in.readInt();
        in.readLong();
        if (ContextPropagator.PROPAGATOR.isOperationWithPayload(operationId) && (payload = ContextPayload.read(in)) != null) {
            Context context = payload.extract();
            SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
            if (spanContext.isValid()) {
                ThreadLocalContext.THREAD_LOCAL_CONTEXT.set(context);
            } else {
                ThreadLocalContext.THREAD_LOCAL_CONTEXT.set(null);
            }
        }
        call.getResultStream(true);
        call.releaseInputStream();
        call.releaseOutputStream();
        call.done();
    }

    public static class NoopRemote
    implements Remote {
    }
}

