/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.rmi.server;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.util.ClassAndMethod;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.rmi.ThreadLocalContext;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.rmi.server.RmiServerSingletons;
import java.rmi.Remote;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class RemoteServerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"java.rmi.Remote")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.nameStartsWith((String)"org.springframework.remoting")));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())), this.getClass().getName() + "$PublicMethodAdvice");
    }

    public static class PublicMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Origin(value="#t") Class<?> declaringClass, @Advice.Origin(value="#m") String methodName, @Advice.Local(value="otelCallDepth") CallDepth callDepth, @Advice.Local(value="otelRequest") ClassAndMethod request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            callDepth = CallDepth.forClass(Remote.class);
            if (callDepth.getAndIncrement() > 0) {
                return;
            }
            Context parentContext = ThreadLocalContext.THREAD_LOCAL_CONTEXT.getAndResetContext();
            if (parentContext == null) {
                return;
            }
            request = ClassAndMethod.create(declaringClass, (String)methodName);
            if (!RmiServerSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = RmiServerSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelCallDepth") CallDepth callDepth, @Advice.Local(value="otelRequest") ClassAndMethod request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (callDepth.decrementAndGet() > 0) {
                return;
            }
            if (scope == null) {
                return;
            }
            scope.close();
            RmiServerSingletons.instrumenter().end(context, (Object)request, null, throwable);
        }
    }
}

