/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.bootstrap.HelperResources;
import io.opentelemetry.javaagent.bootstrap.InjectedClassHelper;
import io.opentelemetry.javaagent.tooling.HelperInjectorListener;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResource;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.utility.JavaModule;

public class HelperInjector
implements AgentBuilder.Transformer {
    private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(HelperInjector.class);
    private static volatile HelperInjectorListener helperInjectorListener;
    private static final ClassLoader BOOTSTRAP_CLASSLOADER_PLACEHOLDER;
    private static final HelperClassInjector BOOT_CLASS_INJECTOR;
    private static final Cache<ClassLoader, Map<String, HelperClassInjector>> helperInjectors;
    private final String requestingName;
    private final Set<String> helperClassNames;
    private final List<HelperResource> helperResources;
    @Nullable
    private final ClassLoader helpersSource;
    @Nullable
    private final Instrumentation instrumentation;
    private final Map<String, byte[]> dynamicTypeMap = new LinkedHashMap<String, byte[]>();
    private final Cache<ClassLoader, Boolean> injectedClassLoaders = Cache.weak();
    private final Cache<ClassLoader, Boolean> resourcesInjectedClassLoaders = Cache.weak();

    public HelperInjector(String requestingName, List<String> helperClassNames, List<HelperResource> helperResources, ClassLoader helpersSource, Instrumentation instrumentation) {
        this.requestingName = requestingName;
        this.helperClassNames = new LinkedHashSet<String>(helperClassNames);
        this.helperResources = helperResources;
        this.helpersSource = helpersSource;
        this.instrumentation = instrumentation;
    }

    private HelperInjector(String requestingName, Map<String, byte[]> helperMap, Instrumentation instrumentation) {
        this.requestingName = requestingName;
        this.helperClassNames = helperMap.keySet();
        this.dynamicTypeMap.putAll(helperMap);
        this.helperResources = Collections.emptyList();
        this.helpersSource = null;
        this.instrumentation = instrumentation;
    }

    public static HelperInjector forDynamicTypes(String requestingName, Collection<DynamicType.Unloaded<?>> helpers, Instrumentation instrumentation) {
        HashMap<String, byte[]> bytes = new HashMap<String, byte[]>(helpers.size());
        for (DynamicType.Unloaded<?> helper : helpers) {
            bytes.put(helper.getTypeDescription().getName(), helper.getBytes());
        }
        return new HelperInjector(requestingName, bytes, instrumentation);
    }

    public static void setHelperInjectorListener(HelperInjectorListener listener) {
        helperInjectorListener = listener;
    }

    private Map<String, byte[]> getHelperMap() throws IOException {
        if (this.dynamicTypeMap.isEmpty()) {
            LinkedHashMap<String, byte[]> classnameToBytes = new LinkedHashMap<String, byte[]>();
            ClassFileLocator locator = ClassFileLocator.ForClassLoader.of((ClassLoader)this.helpersSource);
            for (String helperClassName : this.helperClassNames) {
                byte[] classBytes = locator.locate(helperClassName).resolve();
                classnameToBytes.put(helperClassName, classBytes);
            }
            return classnameToBytes;
        }
        return this.dynamicTypeMap;
    }

    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, ProtectionDomain protectionDomain) {
        if (!this.helperClassNames.isEmpty()) {
            this.injectHelperClasses(typeDescription, classLoader);
        }
        if (classLoader != null && this.helpersSource != null && !this.helperResources.isEmpty()) {
            this.injectHelperResources(classLoader);
        }
        return builder;
    }

    private void injectHelperResources(ClassLoader classLoader) {
        this.resourcesInjectedClassLoaders.computeIfAbsent((Object)classLoader, cl -> {
            for (HelperResource helperResource : this.helperResources) {
                ArrayList<URL> resources;
                try {
                    resources = Collections.list(this.helpersSource.getResources(helperResource.getAgentPath()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Unexpected exception occurred when loading resources {}; skipping", new Object[]{helperResource.getAgentPath()}, e);
                    continue;
                }
                if (resources.isEmpty()) {
                    logger.log(Level.FINE, "Helper resources {0} requested but not found.", helperResource.getAgentPath());
                    continue;
                }
                if (helperResource.allClassLoaders()) {
                    logger.log(Level.FINE, "Injecting resources onto all classloaders: {0}", helperResource.getApplicationPath());
                    HelperResources.registerForAllClassLoaders((String)helperResource.getApplicationPath(), resources);
                    continue;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Injecting resources onto class loader {0} -> {1}", new Object[]{classLoader, helperResource.getApplicationPath()});
                }
                HelperResources.register((ClassLoader)classLoader, (String)helperResource.getApplicationPath(), resources);
            }
            return true;
        });
    }

    private void injectHelperClasses(TypeDescription typeDescription, ClassLoader classLoader) {
        if ((classLoader = HelperInjector.maskNullClassLoader(classLoader)) == BOOTSTRAP_CLASSLOADER_PLACEHOLDER && this.instrumentation == null) {
            logger.log(Level.SEVERE, "Cannot inject helpers into the bootstrap class loader without an instance of Instrumentation. Programmer error!");
            return;
        }
        this.injectedClassLoaders.computeIfAbsent((Object)classLoader, cl -> {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Injecting classes onto class loader {0} -> {1}", new Object[]{cl, this.helperClassNames});
                }
                Map<String, byte[]> classnameToBytes = this.getHelperMap();
                Map map = (Map)helperInjectors.computeIfAbsent(cl, unused -> new ConcurrentHashMap());
                for (Map.Entry<String, byte[]> entry : classnameToBytes.entrySet()) {
                    HelperClassInjector injector = HelperInjector.isBootClassLoader(cl) ? BOOT_CLASS_INJECTOR : new HelperClassInjector(entry.getValue());
                    map.put(entry.getKey(), injector);
                }
                if (HelperInjector.isBootClassLoader(cl)) {
                    this.injectBootstrapClassLoader(classnameToBytes);
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "Error preparing helpers while processing {0} for {1}. Failed to inject helper classes into instance {2}", new Object[]{typeDescription, this.requestingName, cl}, e);
                }
                throw new IllegalStateException(e);
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> injectBootstrapClassLoader(Map<String, byte[]> classnameToBytes) throws IOException {
        if (helperInjectorListener != null) {
            helperInjectorListener.onInjection(classnameToBytes);
        }
        if (ClassInjector.UsingUnsafe.isAvailable()) {
            return ClassInjector.UsingUnsafe.ofBootLoader().injectRaw(classnameToBytes);
        }
        File tempDir = HelperInjector.createTempDir();
        try {
            Map map = ClassInjector.UsingInstrumentation.of((File)tempDir, (ClassInjector.UsingInstrumentation.Target)ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, (Instrumentation)this.instrumentation).injectRaw(classnameToBytes);
            return map;
        }
        finally {
            HelperInjector.deleteTempDir(tempDir);
        }
    }

    private static File createTempDir() throws IOException {
        return Files.createTempDirectory("opentelemetry-temp-jars", new FileAttribute[0]).toFile();
    }

    private static void deleteTempDir(File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            file.deleteOnExit();
        }
    }

    private static ClassLoader maskNullClassLoader(ClassLoader classLoader) {
        return classLoader != null ? classLoader : BOOTSTRAP_CLASSLOADER_PLACEHOLDER;
    }

    private static boolean isBootClassLoader(ClassLoader classLoader) {
        return classLoader == BOOTSTRAP_CLASSLOADER_PLACEHOLDER;
    }

    public static boolean isInjectedClass(Class<?> clazz) {
        return HelperInjector.isInjectedClass(clazz.getClassLoader(), clazz.getName());
    }

    public static boolean isInjectedClass(ClassLoader classLoader, String className) {
        Map injectorMap = (Map)helperInjectors.get((Object)HelperInjector.maskNullClassLoader(classLoader));
        if (injectorMap == null) {
            return false;
        }
        return injectorMap.containsKey(className);
    }

    public static Class<?> loadHelperClass(ClassLoader classLoader, String className) {
        if (classLoader == null) {
            throw new IllegalStateException("boot loader not supported");
        }
        Map injectorMap = (Map)helperInjectors.get((Object)classLoader);
        if (injectorMap == null) {
            return null;
        }
        HelperClassInjector helperClassInjector = (HelperClassInjector)injectorMap.get(className);
        if (helperClassInjector == null) {
            return null;
        }
        return helperClassInjector.inject(classLoader, className);
    }

    static {
        InjectedClassHelper.internalSetHelperClassDetector(HelperInjector::isInjectedClass);
        InjectedClassHelper.internalSetHelperClassLoader(HelperInjector::loadHelperClass);
        BOOTSTRAP_CLASSLOADER_PLACEHOLDER = new SecureClassLoader(null){

            public String toString() {
                return "<bootstrap>";
            }
        };
        BOOT_CLASS_INJECTOR = new HelperClassInjector(null){

            @Override
            Class<?> inject(ClassLoader classLoader, String className) {
                throw new UnsupportedOperationException("should not be called");
            }
        };
        helperInjectors = Cache.weak();
    }

    private static class HelperClassInjector {
        private final byte[] bytes;

        HelperClassInjector(byte[] bytes) {
            this.bytes = bytes;
        }

        Class<?> inject(ClassLoader classLoader, String className) {
            Map result = new ClassInjector.UsingReflection(classLoader).injectRaw(Collections.singletonMap(className, this.bytes));
            return (Class)result.get(className);
        }
    }
}

