/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.bootstrap.VirtualFieldAccessorMarker;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import io.opentelemetry.javaagent.tooling.muzzle.AgentLocationStrategy;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;

public class AgentCachingPoolStrategy
implements AgentBuilder.PoolStrategy {
    private static final boolean REFLECTION_ENABLED = InstrumentationConfig.get().getBoolean("otel.instrumentation.internal-reflection.enabled", true);
    private static final Method findLoadedClassMethod = AgentCachingPoolStrategy.getFindLoadedClassMethod();
    static final int TYPE_CAPACITY = 64;
    static final int BOOTSTRAP_HASH = 7236344;
    final Cache<ClassLoader, WeakReference<ClassLoader>> loaderRefCache = Cache.weak();
    final Cache<TypeCacheKey, TypePool.Resolution> sharedResolutionCache = Cache.bounded((int)64);
    final SharedResolutionCacheAdapter bootstrapCacheProvider = new SharedResolutionCacheAdapter(7236344, null, this.sharedResolutionCache);
    private final AgentLocationStrategy locationStrategy;

    public AgentCachingPoolStrategy(AgentLocationStrategy locationStrategy) {
        this.locationStrategy = locationStrategy;
    }

    private static Method getFindLoadedClassMethod() {
        Instrumentation instrumentation = InstrumentationHolder.getInstrumentation();
        if (instrumentation == null) {
            return null;
        }
        if (JavaModule.isSupported()) {
            JavaModule currentModule = JavaModule.ofType(AgentCachingPoolStrategy.class);
            JavaModule javaBase = JavaModule.ofType(ClassLoader.class);
            if (javaBase != null && javaBase.isNamed() && currentModule != null) {
                ClassInjector.UsingInstrumentation.redefineModule((Instrumentation)instrumentation, (JavaModule)javaBase, Collections.emptySet(), Collections.emptyMap(), Collections.singletonMap("java.lang", Collections.singleton(currentModule)), Collections.emptySet(), Collections.emptyMap());
            }
        }
        try {
            Method method = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static boolean canUseFindLoadedClass() {
        return findLoadedClassMethod != null;
    }

    private static Class<?> findLoadedClass(ClassLoader classLoader, String className) {
        try {
            return (Class)findLoadedClassMethod.invoke((Object)classLoader, className);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public AgentTypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader) {
        return new AgentTypePool(this.getCacheProvider(classLoader), classFileLocator, classLoader, TypePool.Default.ReaderMode.FAST);
    }

    public AgentTypePool typePool(ClassFileLocator classFileLocator, ClassLoader classLoader, String name) {
        return this.typePool(classFileLocator, classLoader);
    }

    private TypePool.CacheProvider getCacheProvider(ClassLoader classLoader) {
        if (classLoader == null) {
            return this.bootstrapCacheProvider;
        }
        WeakReference loaderRef = (WeakReference)this.loaderRefCache.computeIfAbsent((Object)classLoader, WeakReference::new);
        int loaderHash = classLoader.hashCode();
        return new SharedResolutionCacheAdapter(loaderHash, loaderRef, this.sharedResolutionCache);
    }

    private static AgentTypePool.LazyTypeDescriptionWithClass newLazyTypeDescriptionWithClass(AgentTypePool pool, AgentCachingPoolStrategy poolStrategy, Class<?> clazz) {
        if (pool.classLoaderRef.get() != clazz.getClassLoader()) {
            ClassFileLocator classFileLocator = poolStrategy.locationStrategy.classFileLocator(clazz.getClassLoader());
            pool = poolStrategy.typePool(classFileLocator, clazz.getClassLoader());
        }
        AgentTypePool agentTypePool = pool;
        Objects.requireNonNull(agentTypePool);
        return agentTypePool.new AgentTypePool.LazyTypeDescriptionWithClass(clazz);
    }

    private class AgentTypePool
    extends TypePool.Default {
        private final ThreadLocal<Boolean> loadingAnnotations;
        private final WeakReference<ClassLoader> classLoaderRef;

        public AgentTypePool(TypePool.CacheProvider cacheProvider, ClassFileLocator classFileLocator, ClassLoader classLoader, TypePool.Default.ReaderMode readerMode) {
            super(cacheProvider, classFileLocator, readerMode);
            this.loadingAnnotations = new ThreadLocal();
            this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        }

        protected TypePool.Resolution doDescribe(String name) {
            return new LazyResolution(this.classLoaderRef, name);
        }

        protected TypePool.Resolution doCache(String name, TypePool.Resolution resolution) {
            return resolution;
        }

        protected TypePool.Resolution doResolve(String name) {
            TypePool.Resolution resolution = this.cacheProvider.find(name);
            if (resolution == null) {
                resolution = this.cacheProvider.register(name, super.doDescribe(name));
            }
            return resolution;
        }

        void enterLoadAnnotations() {
            this.loadingAnnotations.set(Boolean.TRUE);
        }

        void exitLoadAnnotations() {
            this.loadingAnnotations.set(null);
        }

        boolean isLoadingAnnotations() {
            return this.loadingAnnotations.get() != null;
        }

        private LazyTypeDescriptionWithClass newTypeDescription(Class<?> clazz) {
            return AgentCachingPoolStrategy.newLazyTypeDescriptionWithClass(this, AgentCachingPoolStrategy.this, clazz);
        }

        private class LazyTypeDescriptionWithClass
        extends CachingTypeDescription {
            private final WeakReference<Class<?>> classRef;
            private final String name;
            private final int modifiers;
            private volatile TypeDescription.Generic cachedSuperClass;
            private volatile TypeList.Generic cachedInterfaces;

            LazyTypeDescriptionWithClass(Class<?> clazz) {
                this.name = clazz.getName();
                this.modifiers = clazz.getModifiers();
                this.classRef = new WeakReference(clazz);
            }

            public String getName() {
                return this.name;
            }

            public TypeDescription.Generic getSuperClass() {
                if (this.cachedSuperClass == null) {
                    Class clazz = (Class)this.classRef.get();
                    if (clazz == null) {
                        return null;
                    }
                    Class superClass = clazz.getSuperclass();
                    if (superClass == null) {
                        return null;
                    }
                    this.cachedSuperClass = AgentTypePool.this.newTypeDescription(superClass).asGenericType();
                }
                return this.cachedSuperClass;
            }

            public TypeList.Generic getInterfaces() {
                if (this.cachedInterfaces == null) {
                    ArrayList<LazyTypeDescriptionWithClass> result = new ArrayList<LazyTypeDescriptionWithClass>();
                    Class clazz = (Class)this.classRef.get();
                    if (clazz != null) {
                        for (Class<?> interfaceClass : clazz.getInterfaces()) {
                            if (!REFLECTION_ENABLED && VirtualFieldAccessorMarker.class.isAssignableFrom(interfaceClass)) continue;
                            result.add(AgentTypePool.this.newTypeDescription(interfaceClass));
                        }
                    }
                    this.cachedInterfaces = new TypeList.Generic.Explicit(result);
                }
                return this.cachedInterfaces;
            }

            public int getModifiers() {
                return this.modifiers;
            }
        }

        private class LazyResolution
        implements TypePool.Resolution {
            private final WeakReference<ClassLoader> classLoaderRef;
            private final String name;
            private volatile TypeDescription cached;

            LazyResolution(WeakReference<ClassLoader> classLoaderRef, String name) {
                this.classLoaderRef = classLoaderRef;
                this.name = name;
            }

            public boolean isResolved() {
                if (AgentTypePool.this.isLoadingAnnotations()) {
                    return true;
                }
                return AgentTypePool.this.doResolve(this.name).isResolved();
            }

            public TypeDescription resolve() {
                if (this.cached == null) {
                    this.cached = new LazyTypeDescription(this.classLoaderRef, this.name);
                    if (AgentTypePool.this.isLoadingAnnotations()) {
                        this.cached = new AnnotationTypeDescription(this.cached);
                    }
                }
                return this.cached;
            }
        }

        private class LazyTypeDescription
        extends CachingTypeDescription {
            private final WeakReference<ClassLoader> classLoaderRef;
            private final String name;
            private volatile TypeDescription.Generic cachedSuperClass;
            private volatile TypeList.Generic cachedInterfaces;

            LazyTypeDescription(WeakReference<ClassLoader> classLoaderRef, String name) {
                this.classLoaderRef = classLoaderRef;
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public TypeDescription.Generic getSuperClass() {
                if (this.cachedSuperClass == null) {
                    String superName;
                    Class superClass;
                    TypeDescription.Generic superClassDescription = this.delegate().getSuperClass();
                    ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
                    if (AgentCachingPoolStrategy.canUseFindLoadedClass() && classLoader != null && superClassDescription != null && (superClass = AgentCachingPoolStrategy.findLoadedClass(classLoader, superName = superClassDescription.getTypeName())) != null) {
                        superClassDescription = AgentTypePool.this.newTypeDescription(superClass).asGenericType();
                    }
                    this.cachedSuperClass = superClassDescription;
                }
                return this.cachedSuperClass;
            }

            public TypeList.Generic getInterfaces() {
                if (this.cachedInterfaces == null) {
                    TypeList.Generic interfaces = this.delegate().getInterfaces();
                    ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
                    if (AgentCachingPoolStrategy.canUseFindLoadedClass() && classLoader != null && !interfaces.isEmpty()) {
                        ArrayList<LazyTypeDescriptionWithClass> result = new ArrayList<LazyTypeDescriptionWithClass>();
                        for (TypeDescription.Generic interfaceDescription : interfaces) {
                            String interfaceName = interfaceDescription.getTypeName();
                            Class interfaceClass = AgentCachingPoolStrategy.findLoadedClass(classLoader, interfaceName);
                            if (interfaceClass != null) {
                                result.add(AgentTypePool.this.newTypeDescription(interfaceClass));
                                continue;
                            }
                            result.add((LazyTypeDescriptionWithClass)interfaceDescription.asErasure());
                        }
                        interfaces = new TypeList.Generic.Explicit(result);
                    }
                    this.cachedInterfaces = interfaces;
                }
                return this.cachedInterfaces;
            }

            @Override
            public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
                final MethodList<MethodDescription.InDefinedShape> methods = super.getDeclaredMethods();
                class MethodListWrapper
                extends MethodList.AbstractBase<MethodDescription.InDefinedShape> {
                    MethodListWrapper() {
                    }

                    public MethodDescription.InDefinedShape get(int index) {
                        return new LazyAnnotationMethodDescription((MethodDescription.InDefinedShape)methods.get(index));
                    }

                    public int size() {
                        return methods.size();
                    }
                }
                return new MethodListWrapper();
            }

            private class LazyAnnotationMethodDescription
            extends DelegatingMethodDescription {
                LazyAnnotationMethodDescription(MethodDescription.InDefinedShape method) {
                    super(method);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    AgentTypePool.this.enterLoadAnnotations();
                    try {
                        AnnotationList annotationList = this.method.getDeclaredAnnotations();
                        return annotationList;
                    }
                    finally {
                        AgentTypePool.this.exitLoadAnnotations();
                    }
                }
            }
        }

        private abstract class CachingTypeDescription
        extends TypeDescription.AbstractBase.OfSimpleType.WithDelegation {
            private volatile TypeDescription delegate;
            private volatile AnnotationList annotations;
            private volatile MethodList<MethodDescription.InDefinedShape> methods;

            private CachingTypeDescription() {
            }

            protected TypeDescription delegate() {
                if (this.delegate == null) {
                    this.delegate = AgentTypePool.this.doResolve(this.getName()).resolve();
                }
                return this.delegate;
            }

            public AnnotationList getDeclaredAnnotations() {
                if (this.annotations == null) {
                    TypeDescription delegate = this.delegate();
                    AgentTypePool.this.enterLoadAnnotations();
                    try {
                        this.annotations = delegate.getDeclaredAnnotations();
                    }
                    finally {
                        AgentTypePool.this.exitLoadAnnotations();
                    }
                }
                return this.annotations;
            }

            public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
                if (this.methods == null) {
                    this.methods = this.delegate().getDeclaredMethods();
                }
                return this.methods;
            }
        }
    }

    private static final class SharedResolutionCacheAdapter
    implements TypePool.CacheProvider {
        private static final String OBJECT_NAME = "java.lang.Object";
        private static final TypePool.Resolution OBJECT_RESOLUTION = new TypePool.Resolution.Simple(TypeDescription.ForLoadedType.of(Object.class));
        private final int loaderHash;
        private final WeakReference<ClassLoader> loaderRef;
        private final Cache<TypeCacheKey, TypePool.Resolution> sharedResolutionCache;

        SharedResolutionCacheAdapter(int loaderHash, WeakReference<ClassLoader> loaderRef, Cache<TypeCacheKey, TypePool.Resolution> sharedResolutionCache) {
            this.loaderHash = loaderHash;
            this.loaderRef = loaderRef;
            this.sharedResolutionCache = sharedResolutionCache;
        }

        public TypePool.Resolution find(String className) {
            TypePool.Resolution existingResolution = (TypePool.Resolution)this.sharedResolutionCache.get((Object)new TypeCacheKey(this.loaderHash, this.loaderRef, className));
            if (existingResolution != null) {
                return existingResolution;
            }
            if (className.equals(OBJECT_NAME)) {
                return OBJECT_RESOLUTION;
            }
            return null;
        }

        public TypePool.Resolution register(String className, TypePool.Resolution resolution) {
            if (className.equals(OBJECT_NAME)) {
                return resolution;
            }
            this.sharedResolutionCache.put((Object)new TypeCacheKey(this.loaderHash, this.loaderRef, className), (Object)resolution);
            return resolution;
        }

        public void clear() {
        }
    }

    private static class DelegatingMethodDescription
    extends MethodDescription.InDefinedShape.AbstractBase {
        protected final MethodDescription.InDefinedShape method;

        DelegatingMethodDescription(MethodDescription.InDefinedShape method) {
            this.method = method;
        }

        @Nonnull
        public TypeDescription getDeclaringType() {
            return this.method.getDeclaringType();
        }

        public TypeDescription.Generic getReturnType() {
            return this.method.getReturnType();
        }

        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return this.method.getParameters();
        }

        public TypeList.Generic getExceptionTypes() {
            return this.method.getExceptionTypes();
        }

        public AnnotationValue<?, ?> getDefaultValue() {
            return this.method.getDefaultValue();
        }

        public String getInternalName() {
            return this.method.getInternalName();
        }

        public TypeList.Generic getTypeVariables() {
            return this.method.getTypeVariables();
        }

        public int getModifiers() {
            return this.method.getModifiers();
        }

        public AnnotationList getDeclaredAnnotations() {
            return this.method.getDeclaredAnnotations();
        }
    }

    private static class AnnotationTypeDescription
    extends TypeDescription.AbstractBase.OfSimpleType.WithDelegation {
        private final TypeDescription delegate;

        AnnotationTypeDescription(TypeDescription delegate) {
            this.delegate = delegate;
        }

        protected TypeDescription delegate() {
            return this.delegate;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isAnnotation() {
            return true;
        }
    }

    private static final class TypeCacheKey {
        private final int loaderHash;
        private final WeakReference<ClassLoader> loaderRef;
        private final String className;
        private final int hashCode;

        TypeCacheKey(int loaderHash, WeakReference<ClassLoader> loaderRef, String className) {
            this.loaderHash = loaderHash;
            this.loaderRef = loaderRef;
            this.className = className;
            this.hashCode = 31 * loaderHash + className.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TypeCacheKey)) {
                return false;
            }
            TypeCacheKey other = (TypeCacheKey)obj;
            if (this.loaderHash != other.loaderHash) {
                return false;
            }
            if (!this.className.equals(other.className)) {
                return false;
            }
            if (this.loaderRef == other.loaderRef) {
                return true;
            }
            ClassLoader thisLoader = (ClassLoader)this.loaderRef.get();
            if (thisLoader == null) {
                return false;
            }
            ClassLoader otherLoader = (ClassLoader)other.loaderRef.get();
            if (otherLoader == null) {
                return false;
            }
            return thisLoader == otherLoader;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "TypeCacheKey{loaderHash=" + this.loaderHash + ", loaderRef=" + this.loaderRef + ", className='" + this.className + '\'' + '}';
        }
    }
}

