/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import com.google.common.collect.EvictingQueue;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.tooling.muzzle.HelperClassPredicate;
import io.opentelemetry.javaagent.tooling.muzzle.MuzzleCompilationException;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.Utils;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappings;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappingsBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRefBuilder;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;

final class ReferenceCollectingClassVisitor
extends ClassVisitor {
    private final HelperClassPredicate helperClassPredicate;
    private final boolean isAdviceClass;
    private final Map<String, ClassRef> references = new LinkedHashMap<String, ClassRef>();
    private final Set<String> helperClasses = new HashSet<String>();
    private final Set<String> helperSuperClasses = new HashSet<String>();
    private final VirtualFieldMappingsBuilderImpl virtualFieldMappingsBuilder = new VirtualFieldMappingsBuilderImpl();
    private String refSourceClassName;
    private Type refSourceType;

    private static String internalPackageName(String internalName) {
        return internalName.replaceAll("/[^/]+$", "");
    }

    private static Flag.MinimumVisibilityFlag computeMinimumClassAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        if (ReferenceCollectingClassVisitor.internalPackageName(from.getInternalName()).equals(ReferenceCollectingClassVisitor.internalPackageName(to.getInternalName()))) {
            return Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER;
        }
        return Flag.MinimumVisibilityFlag.PUBLIC;
    }

    private static Flag.MinimumVisibilityFlag computeMinimumFieldAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        if (ReferenceCollectingClassVisitor.internalPackageName(from.getInternalName()).equals(ReferenceCollectingClassVisitor.internalPackageName(to.getInternalName()))) {
            return Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER;
        }
        return Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER;
    }

    private static Flag.MinimumVisibilityFlag computeMinimumMethodAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        return Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER;
    }

    private static Type underlyingType(Type type) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        return type;
    }

    ReferenceCollectingClassVisitor(HelperClassPredicate helperClassPredicate, boolean isAdviceClass) {
        super(458752);
        this.helperClassPredicate = helperClassPredicate;
        this.isAdviceClass = isAdviceClass;
    }

    Map<String, ClassRef> getReferences() {
        return this.references;
    }

    Set<String> getHelperClasses() {
        return this.helperClasses;
    }

    Set<String> getHelperSuperClasses() {
        return this.helperSuperClasses;
    }

    VirtualFieldMappings getVirtualFieldMappings() {
        return this.virtualFieldMappingsBuilder.build();
    }

    private void addExtendsReference(ClassRef ref) {
        this.addReference(ref);
        if (this.helperClassPredicate.isHelperClass(ref.getClassName())) {
            this.helperSuperClasses.add(ref.getClassName());
        }
    }

    private void addReference(ClassRef ref) {
        if (!ref.getClassName().startsWith("java.")) {
            ClassRef reference = this.references.get(ref.getClassName());
            if (null == reference) {
                this.references.put(ref.getClassName(), ref);
            } else {
                this.references.put(ref.getClassName(), reference.merge(ref));
            }
        }
        if (this.helperClassPredicate.isHelperClass(ref.getClassName())) {
            this.helperClasses.add(ref.getClassName());
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.refSourceClassName = Utils.getClassName(name);
        this.refSourceType = Type.getType((String)("L" + name + ";"));
        if (!this.isAdviceClass) {
            String fixedSuperClassName = Utils.getClassName(superName);
            this.addExtendsReference(ClassRef.builder(fixedSuperClassName).addSource(this.refSourceClassName).build());
            ArrayList<String> fixedInterfaceNames = new ArrayList<String>(interfaces.length);
            for (String interfaceName : interfaces) {
                String fixedInterfaceName = Utils.getClassName(interfaceName);
                fixedInterfaceNames.add(fixedInterfaceName);
                this.addExtendsReference(ClassRef.builder(fixedInterfaceName).addSource(this.refSourceClassName).build());
            }
            this.addReference(ClassRef.builder(this.refSourceClassName).addSource(this.refSourceClassName).setSuperClassName(fixedSuperClassName).addInterfaceNames(fixedInterfaceNames).addFlag(ReferenceCollectingClassVisitor.computeTypeManifestationFlag(access)).build());
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        Type fieldType = Type.getType((String)descriptor);
        this.addReference(ClassRef.builder(this.refSourceClassName).addSource(this.refSourceClassName).addField(new Source[0], new Flag[0], name, fieldType, true).build());
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (!this.isAdviceClass) {
            Type methodType = Type.getMethodType((String)descriptor);
            Flag.VisibilityFlag visibilityFlag = ReferenceCollectingClassVisitor.computeVisibilityFlag(access);
            Flag.OwnershipFlag ownershipFlag = ReferenceCollectingClassVisitor.computeOwnershipFlag(access);
            Flag.ManifestationFlag manifestationFlag = ReferenceCollectingClassVisitor.computeTypeManifestationFlag(access);
            this.addReference(ClassRef.builder(this.refSourceClassName).addSource(this.refSourceClassName).addMethod(new Source[0], new Flag[]{visibilityFlag, ownershipFlag, manifestationFlag}, name, methodType.getReturnType(), methodType.getArgumentTypes()).build());
        }
        final MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        MethodNode methodNode = new MethodNode(589824, access, name, descriptor, signature, exceptions){

            public void visitEnd() {
                MethodVisitor target;
                super.visitEnd();
                boolean skip = false;
                if (this.invisibleAnnotations != null) {
                    for (AnnotationNode annotationNode : this.invisibleAnnotations) {
                        if (!Type.getDescriptor(NoMuzzle.class).equals(annotationNode.desc)) continue;
                        skip = true;
                        break;
                    }
                }
                Object object = target = skip ? methodVisitor : new AdviceReferenceMethodVisitor(methodVisitor);
                if (target != null) {
                    this.accept(target);
                }
            }
        };
        return new VirtualFieldCollectingMethodVisitor((MethodVisitor)methodNode);
    }

    private static Flag.VisibilityFlag computeVisibilityFlag(int access) {
        if (Flag.VisibilityFlag.PUBLIC.matches(access)) {
            return Flag.VisibilityFlag.PUBLIC;
        }
        if (Flag.VisibilityFlag.PROTECTED.matches(access)) {
            return Flag.VisibilityFlag.PROTECTED;
        }
        if (Flag.VisibilityFlag.PACKAGE.matches(access)) {
            return Flag.VisibilityFlag.PACKAGE;
        }
        return Flag.VisibilityFlag.PRIVATE;
    }

    private static Flag.OwnershipFlag computeOwnershipFlag(int access) {
        if (Flag.OwnershipFlag.STATIC.matches(access)) {
            return Flag.OwnershipFlag.STATIC;
        }
        return Flag.OwnershipFlag.NON_STATIC;
    }

    private static Flag.ManifestationFlag computeTypeManifestationFlag(int access) {
        if (Flag.ManifestationFlag.ABSTRACT.matches(access)) {
            return Flag.ManifestationFlag.ABSTRACT;
        }
        if (Flag.ManifestationFlag.FINAL.matches(access)) {
            return Flag.ManifestationFlag.FINAL;
        }
        return Flag.ManifestationFlag.NON_FINAL;
    }

    private class VirtualFieldCollectingMethodVisitor
    extends MethodVisitor {
        private final EvictingQueue<Type> lastTwoClassConstants;

        VirtualFieldCollectingMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.lastTwoClassConstants = EvictingQueue.create((int)2);
        }

        public void visitInsn(int opcode) {
            this.registerOpcode(opcode, null);
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.registerOpcode(opcode, null);
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.registerOpcode(opcode, null);
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.registerOpcode(opcode, null);
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            this.registerOpcode(opcode, null);
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            String getVirtualFieldDescriptor = Type.getMethodDescriptor((Type)Type.getType(VirtualField.class), (Type[])new Type[]{Type.getType(Class.class), Type.getType(Class.class)});
            Type methodType = Type.getMethodType((String)descriptor);
            Type ownerType = Type.getType((String)("L" + owner + ";"));
            if (Objects.equals(ownerType.getClassName(), "io.opentelemetry.instrumentation.api.util.VirtualField") && Objects.equals(name, "find") && methodType.getDescriptor().equals(getVirtualFieldDescriptor)) {
                if (this.lastTwoClassConstants.remainingCapacity() == 0) {
                    Type type = (Type)this.lastTwoClassConstants.poll();
                    Type fieldType = (Type)this.lastTwoClassConstants.poll();
                    if (type.getSort() != 10) {
                        throw new MuzzleCompilationException("Invalid VirtualField#find(Class, Class) usage: you cannot pass array or primitive types as the field owner type");
                    }
                    if (fieldType.getSort() != 10 && fieldType.getSort() != 9) {
                        throw new MuzzleCompilationException("Invalid VirtualField#find(Class, Class) usage: you cannot pass primitive types as the field type");
                    }
                    ReferenceCollectingClassVisitor.this.virtualFieldMappingsBuilder.register(type.getClassName(), fieldType.getClassName());
                } else {
                    throw new MuzzleCompilationException("Invalid VirtualField#find(Class, Class) usage: you cannot pass variables, method parameters, compute classes; class references need to be passed directly to the find() method");
                }
            }
            this.registerOpcode(opcode, null);
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.registerOpcode(opcode, null);
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object value) {
            this.registerOpcode(18, value);
            super.visitLdcInsn(value);
        }

        private void registerOpcode(int opcode, Object value) {
            if (opcode == 18 && value instanceof Type) {
                Type type = (Type)value;
                this.lastTwoClassConstants.add((Object)type);
                return;
            }
            this.lastTwoClassConstants.poll();
        }
    }

    private class AdviceReferenceMethodVisitor
    extends MethodVisitor {
        private int currentLineNumber;

        public AdviceReferenceMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.currentLineNumber = -1;
        }

        public void visitLineNumber(int line, Label start) {
            this.currentLineNumber = line;
            super.visitLineNumber(line, start);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            Type ownerType = owner.startsWith("[") ? ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)owner)) : Type.getType((String)("L" + owner + ";"));
            Type fieldType = Type.getType((String)descriptor);
            ArrayList<Enum> fieldFlags = new ArrayList<Enum>();
            fieldFlags.add(ReferenceCollectingClassVisitor.computeMinimumFieldAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType));
            fieldFlags.add(opcode == 178 || opcode == 179 ? Flag.OwnershipFlag.STATIC : Flag.OwnershipFlag.NON_STATIC);
            ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(ownerType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType)).addField(new Source[]{new Source(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber)}, fieldFlags.toArray(new Flag[0]), name, fieldType, false).build());
            Type underlyingFieldType = ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)descriptor));
            if (underlyingFieldType.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(underlyingFieldType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, underlyingFieldType)).build());
            }
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            Type ownerType;
            Type methodType = Type.getMethodType((String)descriptor);
            Type type = ownerType = owner.startsWith("[") ? ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)owner)) : Type.getType((String)("L" + owner + ";"));
            if (ownerType.getSort() != 10) {
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                return;
            }
            Type[] returnType = ReferenceCollectingClassVisitor.underlyingType(methodType.getReturnType());
            if (returnType.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(returnType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, (Type)returnType)).build());
            }
            for (Type paramType : methodType.getArgumentTypes()) {
                if ((paramType = ReferenceCollectingClassVisitor.underlyingType(paramType)).getSort() != 10) continue;
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(paramType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, paramType)).build());
            }
            ArrayList<Enum> methodFlags = new ArrayList<Enum>();
            methodFlags.add(opcode == 184 ? Flag.OwnershipFlag.STATIC : Flag.OwnershipFlag.NON_STATIC);
            methodFlags.add(ReferenceCollectingClassVisitor.computeMinimumMethodAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType));
            ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(ownerType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(isInterface ? Flag.ManifestationFlag.INTERFACE : Flag.ManifestationFlag.NON_INTERFACE).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType)).addMethod(new Source[]{new Source(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber)}, methodFlags.toArray(new Flag[0]), name, methodType.getReturnType(), methodType.getArgumentTypes()).build());
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitTypeInsn(int opcode, String type) {
            Type typeObj = ReferenceCollectingClassVisitor.underlyingType(Type.getObjectType((String)type));
            if (typeObj.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(typeObj.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, typeObj)).build());
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(Utils.getClassName(bootstrapMethodHandle.getOwner())).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, Type.getObjectType((String)bootstrapMethodHandle.getOwner()))).build());
            for (Object arg : bootstrapMethodArguments) {
                if (!(arg instanceof Handle)) continue;
                Handle handle = (Handle)arg;
                ClassRefBuilder classRefBuilder = ClassRef.builder(Utils.getClassName(handle.getOwner())).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, Type.getObjectType((String)handle.getOwner())));
                if (handle.getTag() != 5 && handle.getTag() != 6 && handle.getTag() != 7 && handle.getTag() != 8 && handle.getTag() != 9) continue;
                Type methodType = Type.getMethodType((String)handle.getDesc());
                Type ownerType = Type.getObjectType((String)handle.getOwner());
                ArrayList<Enum> methodFlags = new ArrayList<Enum>();
                methodFlags.add(handle.getTag() == 6 ? Flag.OwnershipFlag.STATIC : Flag.OwnershipFlag.NON_STATIC);
                methodFlags.add(ReferenceCollectingClassVisitor.computeMinimumMethodAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType));
                classRefBuilder.addMethod(new Source[]{new Source(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber)}, methodFlags.toArray(new Flag[0]), handle.getName(), methodType.getReturnType(), methodType.getArgumentTypes());
                ReferenceCollectingClassVisitor.this.addReference(classRefBuilder.build());
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        public void visitLdcInsn(Object value) {
            Type type;
            if (value instanceof Type && (type = ReferenceCollectingClassVisitor.underlyingType((Type)value)).getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.builder(type.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag(ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, type)).build());
            }
            super.visitLdcInsn(value);
        }
    }
}

