/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.references;

import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.ReferenceMergeUtil;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public final class MethodRef {
    private final Set<Source> sources;
    private final Set<Flag> flags;
    private final String name;
    private final String descriptor;

    MethodRef(Set<Source> sources, Set<Flag> flags, String name, String descriptor) {
        this.sources = sources;
        this.flags = flags;
        this.name = name;
        this.descriptor = descriptor;
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    MethodRef merge(MethodRef anotherMethod) {
        if (!this.equals(anotherMethod)) {
            throw new IllegalStateException("illegal merge " + this + " != " + anotherMethod);
        }
        return new MethodRef(ReferenceMergeUtil.mergeSet(this.sources, anotherMethod.sources), ReferenceMergeUtil.mergeFlags(this.flags, anotherMethod.flags), this.name, this.descriptor);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodRef)) {
            return false;
        }
        MethodRef other = (MethodRef)obj;
        return this.name.equals(other.name) && this.descriptor.equals(other.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.descriptor);
    }

    public String toString() {
        Type methodType = Type.getMethodType((String)this.getDescriptor());
        String returnType = methodType.getReturnType().getClassName();
        String modifiers = this.flags.stream().map(Object::toString).collect(Collectors.joining(" "));
        String parameters = Stream.of(methodType.getArgumentTypes()).map(Type::getClassName).collect(Collectors.joining(", ", "(", ")"));
        return this.getClass().getSimpleName() + ": " + modifiers + " " + returnType + " " + this.name + parameters;
    }
}

