/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import java.text.MessageFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class TransformSafeLogger {
    private static final boolean ENABLE_TRANSFORM_SAFE_LOGGING = Boolean.getBoolean("otel.javaagent.testing.transform-safe-logging.enabled");
    @Nullable
    private static final BlockingQueue<LogMessage> logMessageQueue;
    private final Logger logger;

    public static TransformSafeLogger getLogger(Class<?> clazz) {
        return new TransformSafeLogger(Logger.getLogger(clazz.getName()));
    }

    private TransformSafeLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, String message) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(level, this.logger, message, null, null));
        } else {
            this.logger.log(level, message);
        }
    }

    public void log(Level level, String message, Object arg) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(level, this.logger, message, null, new Object[]{arg}));
        } else {
            this.logger.log(level, message, arg);
        }
    }

    public void log(Level level, String message, Object[] args) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(level, this.logger, message, null, args));
        } else {
            this.logger.log(level, message, args);
        }
    }

    public void log(Level level, String message, Object[] args, Throwable error) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(level, this.logger, message, error, args));
        } else {
            this.logger.log(level, TransformSafeLogger.formatMessage(message, args), error);
        }
    }

    private static String formatMessage(String format, Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return format;
        }
        return MessageFormat.format(format, arguments);
    }

    static {
        if (ENABLE_TRANSFORM_SAFE_LOGGING) {
            logMessageQueue = new ArrayBlockingQueue<LogMessage>(1000);
            Thread thread = new Thread(new LogMessageQueueReader());
            thread.setName("otel-javaagent-transform-safe-logger");
            thread.setDaemon(true);
            thread.start();
        } else {
            logMessageQueue = null;
        }
    }

    private static class LogMessage {
        private final Level level;
        private final Logger logger;
        private final String format;
        private final Throwable error;
        private final Object[] arguments;

        private LogMessage(Level level, Logger logger, String format, Throwable error, Object[] arguments) {
            this.level = level;
            this.logger = logger;
            this.format = format;
            this.error = error;
            this.arguments = arguments;
        }
    }

    private static class LogMessageQueueReader
    implements Runnable {
        private LogMessageQueueReader() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    LogMessage logMessage = (LogMessage)logMessageQueue.take();
                    logMessage.logger.log(logMessage.level, TransformSafeLogger.formatMessage(logMessage.format, logMessage.arguments), logMessage.error);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

