/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.generation;

import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResource;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResourceBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.ReferenceCollector;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappings;
import io.opentelemetry.javaagent.tooling.muzzle.generation.AdviceClassNameCollector;
import io.opentelemetry.javaagent.tooling.muzzle.generation.Utils;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRefBuilder;
import io.opentelemetry.javaagent.tooling.muzzle.references.FieldRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.MethodRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class MuzzleCodeGenerator
implements AsmVisitorWrapper {
    private static final Logger logger = Logger.getLogger(MuzzleCodeGenerator.class.getName());
    private static final String MUZZLE_REFERENCES_METHOD_NAME = "getMuzzleReferences";
    private static final String MUZZLE_HELPER_CLASSES_METHOD_NAME = "getMuzzleHelperClassNames";
    private static final String MUZZLE_VIRTUAL_FIELDS_METHOD_NAME = "registerMuzzleVirtualFields";
    private final URLClassLoader classLoader;

    public MuzzleCodeGenerator(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int mergeWriter(int flags) {
        return flags | 1;
    }

    public int mergeReader(int flags) {
        return flags;
    }

    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new GenerateMuzzleMethodsAndFields(classVisitor, this.classLoader);
    }

    private static class GenerateMuzzleMethodsAndFields
    extends ClassVisitor {
        private final String[] defaultInterfaces = new String[]{Utils.getInternalName(InstrumentationModuleMuzzle.class)};
        private final URLClassLoader classLoader;
        private String instrumentationClassName;
        private InstrumentationModule instrumentationModule;
        private boolean generateReferencesMethod = true;
        private boolean generateHelperClassNamesMethod = true;
        private boolean generateVirtualFieldsMethod = true;
        private static final Pattern ANONYMOUS_ENUM_CONSTANT_CLASS = Pattern.compile("(?<enumClass>.*)\\$[0-9]+$");

        public GenerateMuzzleMethodsAndFields(ClassVisitor classVisitor, URLClassLoader classLoader) {
            super(458752, classVisitor);
            this.classLoader = classLoader;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.instrumentationClassName = name;
            try {
                this.instrumentationModule = (InstrumentationModule)this.classLoader.loadClass(Utils.getClassName(this.instrumentationClassName)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            super.visit(version, access, name, signature, superName, this.addMuzzleInterface(interfaces));
        }

        private String[] addMuzzleInterface(String[] interfaces) {
            if (interfaces == null) {
                return this.defaultInterfaces;
            }
            String[] allInterfaces = new String[interfaces.length + 1];
            allInterfaces[0] = Utils.getInternalName(InstrumentationModuleMuzzle.class);
            System.arraycopy(interfaces, 0, allInterfaces, 1, interfaces.length);
            return allInterfaces;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (MuzzleCodeGenerator.MUZZLE_REFERENCES_METHOD_NAME.equals(name)) {
                this.generateReferencesMethod = false;
                this.logMethodAlreadyExistsMessage(MuzzleCodeGenerator.MUZZLE_REFERENCES_METHOD_NAME);
            }
            if (MuzzleCodeGenerator.MUZZLE_HELPER_CLASSES_METHOD_NAME.equals(name)) {
                this.generateHelperClassNamesMethod = false;
                this.logMethodAlreadyExistsMessage(MuzzleCodeGenerator.MUZZLE_HELPER_CLASSES_METHOD_NAME);
            }
            if (MuzzleCodeGenerator.MUZZLE_VIRTUAL_FIELDS_METHOD_NAME.equals(name)) {
                this.generateVirtualFieldsMethod = false;
                this.logMethodAlreadyExistsMessage(MuzzleCodeGenerator.MUZZLE_VIRTUAL_FIELDS_METHOD_NAME);
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        private void logMethodAlreadyExistsMessage(String muzzleVirtualFieldsMethodName) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "The \"{0}\" method was already found in class \"{1}\". Muzzle will not generate it again", new Object[]{muzzleVirtualFieldsMethodName, this.instrumentationClassName});
            }
        }

        public void visitEnd() {
            ReferenceCollector collector = this.collectReferences();
            if (this.generateReferencesMethod) {
                this.generateMuzzleReferencesMethod(collector);
            }
            if (this.generateHelperClassNamesMethod) {
                this.generateMuzzleHelperClassNamesMethod(collector);
            }
            if (this.generateVirtualFieldsMethod) {
                this.generateMuzzleVirtualFieldsMethod(collector);
            }
            super.visitEnd();
        }

        private ReferenceCollector collectReferences() {
            AdviceClassNameCollector adviceClassNameCollector = new AdviceClassNameCollector();
            for (TypeInstrumentation typeInstrumentation : this.instrumentationModule.typeInstrumentations()) {
                typeInstrumentation.transform((TypeTransformer)adviceClassNameCollector);
            }
            URLClassLoader resourceLoader = new URLClassLoader(this.classLoader.getURLs(), null);
            ReferenceCollector collector = new ReferenceCollector(arg_0 -> ((InstrumentationModule)this.instrumentationModule).isHelperClass(arg_0), resourceLoader);
            for (String adviceClass : adviceClassNameCollector.getAdviceClassNames()) {
                collector.collectReferencesFromAdvice(adviceClass);
            }
            HelperResourceBuilderImpl helperResourceBuilder = new HelperResourceBuilderImpl();
            this.instrumentationModule.registerHelperResources((HelperResourceBuilder)helperResourceBuilder);
            for (HelperResource resource : helperResourceBuilder.getResources()) {
                collector.collectReferencesFromResource(resource);
            }
            collector.prune();
            return collector;
        }

        private void generateMuzzleReferencesMethod(ReferenceCollector collector) {
            Type referenceType = Type.getType(ClassRef.class);
            Type referenceBuilderType = Type.getType(ClassRefBuilder.class);
            Type referenceFlagType = Type.getType(Flag.class);
            Type referenceFlagArrayType = Type.getType(Flag[].class);
            Type referenceSourceArrayType = Type.getType(Source[].class);
            Type stringType = Type.getType(String.class);
            Type typeType = Type.getType(Type.class);
            Type typeArrayType = Type.getType(Type[].class);
            MethodVisitor mv = super.visitMethod(1, MuzzleCodeGenerator.MUZZLE_REFERENCES_METHOD_NAME, "()Ljava/util/Map;", null, null);
            mv.visitCode();
            Collection<ClassRef> references = collector.getReferences().values();
            GenerateMuzzleMethodsAndFields.writeNewMap(mv, references.size());
            mv.visitVarInsn(58, 1);
            references.forEach(reference -> {
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn((Object)reference.getClassName());
                mv.visitLdcInsn((Object)reference.getClassName());
                mv.visitMethodInsn(184, referenceType.getInternalName(), "builder", Type.getMethodDescriptor((Type)referenceBuilderType, (Type[])new Type[]{stringType}), false);
                for (Source source : reference.getSources()) {
                    mv.visitLdcInsn((Object)source.getName());
                    mv.visitLdcInsn((Object)source.getLine());
                    mv.visitMethodInsn(182, referenceBuilderType.getInternalName(), "addSource", Type.getMethodDescriptor((Type)referenceBuilderType, (Type[])new Type[]{stringType, Type.INT_TYPE}), false);
                }
                for (Flag flag : reference.getFlags()) {
                    String enumClassName = GenerateMuzzleMethodsAndFields.getEnumClassInternalName(flag);
                    mv.visitFieldInsn(178, enumClassName, flag.name(), "L" + enumClassName + ";");
                    mv.visitMethodInsn(182, referenceBuilderType.getInternalName(), "addFlag", Type.getMethodDescriptor((Type)referenceBuilderType, (Type[])new Type[]{referenceFlagType}), false);
                }
                if (null != reference.getSuperClassName()) {
                    mv.visitLdcInsn((Object)reference.getSuperClassName());
                    mv.visitMethodInsn(182, referenceBuilderType.getInternalName(), "setSuperClassName", Type.getMethodDescriptor((Type)referenceBuilderType, (Type[])new Type[]{stringType}), false);
                }
                for (String interfaceName : reference.getInterfaceNames()) {
                    mv.visitLdcInsn((Object)interfaceName);
                    mv.visitMethodInsn(182, referenceBuilderType.getInternalName(), "addInterfaceName", Type.getMethodDescriptor((Type)referenceBuilderType, (Type[])new Type[]{stringType}), false);
                }
                for (FieldRef field : reference.getFields()) {
                    GenerateMuzzleMethodsAndFields.writeSourcesArray(mv, field.getSources());
                    GenerateMuzzleMethodsAndFields.writeFlagsArray(mv, field.getFlags());
                    mv.visitLdcInsn((Object)field.getName());
                    GenerateMuzzleMethodsAndFields.writeType(mv, field.getDescriptor());
                    mv.visitLdcInsn((Object)field.isDeclared());
                    mv.visitMethodInsn(182, referenceBuilderType.getInternalName(), "addField", Type.getMethodDescriptor((Type)referenceBuilderType, (Type[])new Type[]{referenceSourceArrayType, referenceFlagArrayType, stringType, typeType, Type.BOOLEAN_TYPE}), false);
                }
                for (MethodRef method : reference.getMethods()) {
                    GenerateMuzzleMethodsAndFields.writeSourcesArray(mv, method.getSources());
                    GenerateMuzzleMethodsAndFields.writeFlagsArray(mv, method.getFlags());
                    mv.visitLdcInsn((Object)method.getName());
                    Type methodType = Type.getMethodType((String)method.getDescriptor());
                    GenerateMuzzleMethodsAndFields.writeType(mv, methodType.getReturnType().getDescriptor());
                    mv.visitLdcInsn((Object)methodType.getArgumentTypes().length);
                    mv.visitTypeInsn(189, typeType.getInternalName());
                    int i = 0;
                    for (Type parameterType : methodType.getArgumentTypes()) {
                        mv.visitInsn(89);
                        mv.visitLdcInsn((Object)i);
                        GenerateMuzzleMethodsAndFields.writeType(mv, parameterType.getDescriptor());
                        mv.visitInsn(83);
                        ++i;
                    }
                    mv.visitMethodInsn(182, referenceBuilderType.getInternalName(), "addMethod", Type.getMethodDescriptor((Type)referenceBuilderType, (Type[])new Type[]{referenceSourceArrayType, referenceFlagArrayType, stringType, typeType, typeArrayType}), false);
                }
                mv.visitMethodInsn(182, referenceBuilderType.getInternalName(), "build", Type.getMethodDescriptor((Type)referenceType, (Type[])new Type[0]), false);
                mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                mv.visitInsn(87);
            });
            mv.visitVarInsn(25, 1);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private static void writeNewMap(MethodVisitor mv, int size) {
            mv.visitTypeInsn(187, "java/util/HashMap");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)((int)((float)size / 0.75f) + 1));
            mv.visitLdcInsn((Object)Float.valueOf(0.75f));
            mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "(IF)V", false);
        }

        private static void writeSourcesArray(MethodVisitor mv, Set<Source> sources) {
            Type referenceSourceType = Type.getType(Source.class);
            mv.visitLdcInsn((Object)sources.size());
            mv.visitTypeInsn(189, referenceSourceType.getInternalName());
            int i = 0;
            for (Source source : sources) {
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)i);
                mv.visitTypeInsn(187, referenceSourceType.getInternalName());
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)source.getName());
                mv.visitLdcInsn((Object)source.getLine());
                mv.visitMethodInsn(183, referenceSourceType.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
                mv.visitInsn(83);
                ++i;
            }
        }

        private static void writeFlagsArray(MethodVisitor mv, Set<Flag> flags) {
            Type referenceFlagType = Type.getType(Flag.class);
            mv.visitLdcInsn((Object)flags.size());
            mv.visitTypeInsn(189, referenceFlagType.getInternalName());
            int i = 0;
            for (Flag flag : flags) {
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)i);
                String enumClassName = GenerateMuzzleMethodsAndFields.getEnumClassInternalName(flag);
                mv.visitFieldInsn(178, enumClassName, flag.name(), "L" + enumClassName + ";");
                mv.visitInsn(83);
                ++i;
            }
        }

        private static String getEnumClassInternalName(Flag flag) {
            String fullInternalName = Utils.getInternalName(flag.getClass());
            Matcher m = ANONYMOUS_ENUM_CONSTANT_CLASS.matcher(fullInternalName);
            return m.matches() ? m.group("enumClass") : fullInternalName;
        }

        private static void writeType(MethodVisitor mv, String descriptor) {
            Type typeType = Type.getType(Type.class);
            mv.visitLdcInsn((Object)descriptor);
            mv.visitMethodInsn(184, typeType.getInternalName(), "getType", Type.getMethodDescriptor((Type)typeType, (Type[])new Type[]{Type.getType(String.class)}), false);
        }

        private void generateMuzzleHelperClassNamesMethod(ReferenceCollector collector) {
            MethodVisitor mv = super.visitMethod(1, MuzzleCodeGenerator.MUZZLE_HELPER_CLASSES_METHOD_NAME, "()Ljava/util/List;", null, null);
            mv.visitCode();
            List<String> helperClassNames = collector.getSortedHelperClasses();
            mv.visitTypeInsn(187, "java/util/ArrayList");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)helperClassNames.size());
            mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V", false);
            mv.visitVarInsn(58, 1);
            helperClassNames.forEach(helperClassName -> {
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn(helperClassName);
                mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
                mv.visitInsn(87);
            });
            mv.visitVarInsn(25, 1);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateMuzzleVirtualFieldsMethod(ReferenceCollector collector) {
            MethodVisitor mv = super.visitMethod(1, MuzzleCodeGenerator.MUZZLE_VIRTUAL_FIELDS_METHOD_NAME, "(Lio/opentelemetry/javaagent/tooling/muzzle/VirtualFieldMappingsBuilder;)V", null, null);
            mv.visitCode();
            VirtualFieldMappings virtualFieldMappings = collector.getVirtualFieldMappings();
            mv.visitVarInsn(25, 1);
            virtualFieldMappings.forEach((typeName, fieldTypeName) -> {
                mv.visitLdcInsn(typeName);
                mv.visitLdcInsn(fieldTypeName);
                mv.visitMethodInsn(185, "io/opentelemetry/javaagent/tooling/muzzle/VirtualFieldMappingsBuilder", "register", "(Ljava/lang/String;Ljava/lang/String;)Lio/opentelemetry/javaagent/tooling/muzzle/VirtualFieldMappingsBuilder;", true);
            });
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }
}

