/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import io.opentelemetry.javaagent.extension.muzzle.ClassRef;
import io.opentelemetry.javaagent.extension.muzzle.FieldRef;
import io.opentelemetry.javaagent.extension.muzzle.Flag;
import io.opentelemetry.javaagent.extension.muzzle.MethodRef;
import io.opentelemetry.javaagent.extension.muzzle.Source;
import io.opentelemetry.javaagent.tooling.muzzle.HelperReferenceWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.jar.asm.Type;

public abstract class Mismatch {
    private final Collection<Source> mismatchSources;

    private Mismatch(Collection<Source> mismatchSources) {
        this.mismatchSources = mismatchSources;
    }

    public String toString() {
        if (this.mismatchSources.size() > 0) {
            return this.mismatchSources.iterator().next().toString() + " " + this.getMismatchDetails();
        }
        return "<no-source> " + this.getMismatchDetails();
    }

    abstract String getMismatchDetails();

    public static class HelperClassesInjectionError
    extends Mismatch {
        public HelperClassesInjectionError() {
            super(Collections.emptyList());
        }

        @Override
        String getMismatchDetails() {
            return "Failed to inject helper classes. Are Helpers being injected in the correct order?";
        }
    }

    public static class InstrumentationModuleClassLoaderMismatch
    extends Mismatch {
        public InstrumentationModuleClassLoaderMismatch() {
            super(Collections.emptyList());
        }

        @Override
        String getMismatchDetails() {
            return "InstrumentationModule classloader check";
        }
    }

    public static class ReferenceCheckError
    extends Mismatch {
        private final Exception referenceCheckException;
        private final ClassRef referenceBeingChecked;
        private final ClassLoader classLoaderBeingChecked;

        public ReferenceCheckError(Exception e, ClassRef referenceBeingChecked, ClassLoader classLoaderBeingChecked) {
            super(Collections.emptyList());
            this.referenceCheckException = e;
            this.referenceBeingChecked = referenceBeingChecked;
            this.classLoaderBeingChecked = classLoaderBeingChecked;
        }

        @Override
        String getMismatchDetails() {
            StringWriter sw = new StringWriter();
            sw.write("Failed to generate reference check for: ");
            sw.write(this.referenceBeingChecked.toString());
            sw.write(" on classloader ");
            sw.write(this.classLoaderBeingChecked.toString());
            sw.write("\n");
            PrintWriter pw = new PrintWriter(sw);
            this.referenceCheckException.printStackTrace(pw);
            return sw.toString();
        }
    }

    public static class MissingMethod
    extends Mismatch {
        private final String className;
        private final String methodName;
        private final String methodDescriptor;

        public MissingMethod(ClassRef classRef, MethodRef methodRef) {
            super(methodRef.getSources());
            this.className = classRef.getClassName();
            this.methodName = methodRef.getName();
            this.methodDescriptor = methodRef.getDescriptor();
        }

        public MissingMethod(ClassRef classRef, HelperReferenceWrapper.Method method) {
            super(classRef.getSources());
            this.className = method.getDeclaringClass();
            this.methodName = method.getName();
            this.methodDescriptor = method.getDescriptor();
        }

        @Override
        String getMismatchDetails() {
            return "Missing method " + this.className + "#" + this.methodName + this.methodDescriptor;
        }
    }

    public static class MissingField
    extends Mismatch {
        private final String className;
        private final String fieldName;
        private final String fieldDescriptor;

        MissingField(ClassRef classRef, FieldRef fieldRef) {
            super(fieldRef.getSources());
            this.className = classRef.getClassName();
            this.fieldName = fieldRef.getName();
            this.fieldDescriptor = fieldRef.getDescriptor();
        }

        MissingField(ClassRef classRef, HelperReferenceWrapper.Field field) {
            super(classRef.getSources());
            this.className = classRef.getClassName();
            this.fieldName = field.getName();
            this.fieldDescriptor = field.getDescriptor();
        }

        @Override
        String getMismatchDetails() {
            return "Missing field " + Type.getType((String)this.fieldDescriptor).getClassName() + " " + this.fieldName + " in class " + this.className;
        }
    }

    public static class MissingFlag
    extends Mismatch {
        private final Flag expectedFlag;
        private final String classMethodOrFieldDesc;
        private final int foundAccess;

        public MissingFlag(Collection<Source> sources, String classMethodOrFieldDesc, Flag expectedFlag, int foundAccess) {
            super(sources);
            this.classMethodOrFieldDesc = classMethodOrFieldDesc;
            this.expectedFlag = expectedFlag;
            this.foundAccess = foundAccess;
        }

        @Override
        String getMismatchDetails() {
            return this.classMethodOrFieldDesc + " requires flag " + this.expectedFlag + " found " + this.foundAccess;
        }
    }

    public static class MissingClass
    extends Mismatch {
        private final String className;

        public MissingClass(ClassRef classRef) {
            super(classRef.getSources());
            this.className = classRef.getClassName();
        }

        public MissingClass(ClassRef classRef, String className) {
            super(classRef.getSources());
            this.className = className;
        }

        @Override
        String getMismatchDetails() {
            return "Missing class " + this.className;
        }
    }
}

