/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import com.google.common.collect.EvictingQueue;
import io.opentelemetry.javaagent.extension.muzzle.ClassRef;
import io.opentelemetry.javaagent.extension.muzzle.Flag;
import io.opentelemetry.javaagent.extension.muzzle.Source;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationClassPredicate;
import io.opentelemetry.javaagent.tooling.muzzle.MuzzleCompilationException;
import io.opentelemetry.javaagent.tooling.muzzle.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

final class ReferenceCollectingClassVisitor
extends ClassVisitor {
    private final InstrumentationClassPredicate instrumentationClassPredicate;
    private final boolean isAdviceClass;
    private final Map<String, ClassRef> references = new LinkedHashMap<String, ClassRef>();
    private final Set<String> helperClasses = new HashSet<String>();
    private final Set<String> helperSuperClasses = new HashSet<String>();
    private final Map<String, String> contextStoreClasses = new LinkedHashMap<String, String>();
    private String refSourceClassName;
    private Type refSourceType;

    private static String internalPackageName(String internalName) {
        return internalName.replaceAll("/[^/]+$", "");
    }

    private static Flag.MinimumVisibilityFlag computeMinimumClassAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        if (ReferenceCollectingClassVisitor.internalPackageName(from.getInternalName()).equals(ReferenceCollectingClassVisitor.internalPackageName(to.getInternalName()))) {
            return Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER;
        }
        return Flag.MinimumVisibilityFlag.PUBLIC;
    }

    private static Flag.MinimumVisibilityFlag computeMinimumFieldAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        if (ReferenceCollectingClassVisitor.internalPackageName(from.getInternalName()).equals(ReferenceCollectingClassVisitor.internalPackageName(to.getInternalName()))) {
            return Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER;
        }
        return Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER;
    }

    private static Flag.MinimumVisibilityFlag computeMinimumMethodAccess(Type from, Type to) {
        if (from.getInternalName().equalsIgnoreCase(to.getInternalName())) {
            return Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER;
        }
        return Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER;
    }

    private static Type underlyingType(Type type) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        return type;
    }

    ReferenceCollectingClassVisitor(InstrumentationClassPredicate instrumentationClassPredicate, boolean isAdviceClass) {
        super(458752);
        this.instrumentationClassPredicate = instrumentationClassPredicate;
        this.isAdviceClass = isAdviceClass;
    }

    Map<String, ClassRef> getReferences() {
        return this.references;
    }

    Set<String> getHelperClasses() {
        return this.helperClasses;
    }

    Set<String> getHelperSuperClasses() {
        return this.helperSuperClasses;
    }

    Map<String, String> getContextStoreClasses() {
        return this.contextStoreClasses;
    }

    private void addExtendsReference(ClassRef ref) {
        this.addReference(ref);
        if (this.instrumentationClassPredicate.isInstrumentationClass(ref.getClassName())) {
            this.helperSuperClasses.add(ref.getClassName());
        }
    }

    private void addReference(ClassRef ref) {
        if (!ref.getClassName().startsWith("java.")) {
            ClassRef reference = this.references.get(ref.getClassName());
            if (null == reference) {
                this.references.put(ref.getClassName(), ref);
            } else {
                this.references.put(ref.getClassName(), reference.merge(ref));
            }
        }
        if (this.instrumentationClassPredicate.isInstrumentationClass(ref.getClassName())) {
            this.helperClasses.add(ref.getClassName());
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.refSourceClassName = Utils.getClassName(name);
        this.refSourceType = Type.getType((String)("L" + name + ";"));
        if (!this.isAdviceClass) {
            String fixedSuperClassName = Utils.getClassName(superName);
            this.addExtendsReference(ClassRef.newBuilder((String)fixedSuperClassName).addSource(this.refSourceClassName).build());
            ArrayList<String> fixedInterfaceNames = new ArrayList<String>(interfaces.length);
            for (String interfaceName : interfaces) {
                String fixedInterfaceName = Utils.getClassName(interfaceName);
                fixedInterfaceNames.add(fixedInterfaceName);
                this.addExtendsReference(ClassRef.newBuilder((String)fixedInterfaceName).addSource(this.refSourceClassName).build());
            }
            this.addReference(ClassRef.newBuilder((String)this.refSourceClassName).addSource(this.refSourceClassName).setSuperClassName(fixedSuperClassName).addInterfaceNames(fixedInterfaceNames).addFlag((Flag)ReferenceCollectingClassVisitor.computeTypeManifestationFlag(access)).build());
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        Type fieldType = Type.getType((String)descriptor);
        this.addReference(ClassRef.newBuilder((String)this.refSourceClassName).addSource(this.refSourceClassName).addField(new Source[0], new Flag[0], name, fieldType, true).build());
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (!this.isAdviceClass) {
            Type methodType = Type.getMethodType((String)descriptor);
            Flag.VisibilityFlag visibilityFlag = ReferenceCollectingClassVisitor.computeVisibilityFlag(access);
            Flag.OwnershipFlag ownershipFlag = ReferenceCollectingClassVisitor.computeOwnershipFlag(access);
            Flag.ManifestationFlag manifestationFlag = ReferenceCollectingClassVisitor.computeTypeManifestationFlag(access);
            this.addReference(ClassRef.newBuilder((String)this.refSourceClassName).addSource(this.refSourceClassName).addMethod(new Source[0], new Flag[]{visibilityFlag, ownershipFlag, manifestationFlag}, name, methodType.getReturnType(), methodType.getArgumentTypes()).build());
        }
        return new AdviceReferenceMethodVisitor(new InstrumentationContextMethodVisitor(super.visitMethod(access, name, descriptor, signature, exceptions)));
    }

    private static Flag.VisibilityFlag computeVisibilityFlag(int access) {
        if (Flag.VisibilityFlag.PUBLIC.matches(access)) {
            return Flag.VisibilityFlag.PUBLIC;
        }
        if (Flag.VisibilityFlag.PROTECTED.matches(access)) {
            return Flag.VisibilityFlag.PROTECTED;
        }
        if (Flag.VisibilityFlag.PACKAGE.matches(access)) {
            return Flag.VisibilityFlag.PACKAGE;
        }
        return Flag.VisibilityFlag.PRIVATE;
    }

    private static Flag.OwnershipFlag computeOwnershipFlag(int access) {
        if (Flag.OwnershipFlag.STATIC.matches(access)) {
            return Flag.OwnershipFlag.STATIC;
        }
        return Flag.OwnershipFlag.NON_STATIC;
    }

    private static Flag.ManifestationFlag computeTypeManifestationFlag(int access) {
        if (Flag.ManifestationFlag.ABSTRACT.matches(access)) {
            return Flag.ManifestationFlag.ABSTRACT;
        }
        if (Flag.ManifestationFlag.FINAL.matches(access)) {
            return Flag.ManifestationFlag.FINAL;
        }
        return Flag.ManifestationFlag.NON_FINAL;
    }

    private class InstrumentationContextMethodVisitor
    extends MethodVisitor {
        private final EvictingQueue<String> lastTwoClassConstants;

        InstrumentationContextMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.lastTwoClassConstants = EvictingQueue.create((int)2);
        }

        public void visitInsn(int opcode) {
            this.registerOpcode(opcode, null);
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.registerOpcode(opcode, null);
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.registerOpcode(opcode, null);
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.registerOpcode(opcode, null);
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            this.registerOpcode(opcode, null);
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            Type methodType = Type.getMethodType((String)descriptor);
            Type ownerType = Type.getType((String)("L" + owner + ";"));
            if ("io.opentelemetry.javaagent.instrumentation.api.InstrumentationContext".equals(ownerType.getClassName()) && "get".equals(name) && methodType.getArgumentTypes().length == 2) {
                if (this.lastTwoClassConstants.remainingCapacity() == 0) {
                    String className = (String)this.lastTwoClassConstants.poll();
                    String contextClassName = (String)this.lastTwoClassConstants.poll();
                    ReferenceCollectingClassVisitor.this.contextStoreClasses.put(className, contextClassName);
                } else {
                    throw new MuzzleCompilationException("Invalid InstrumentationContext#get(Class, Class) usage: you cannot pass variables, method parameters, compute classes; class references need to be passed directly to the get() method");
                }
            }
            this.registerOpcode(opcode, null);
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.registerOpcode(opcode, null);
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object value) {
            this.registerOpcode(18, value);
            super.visitLdcInsn(value);
        }

        private void registerOpcode(int opcode, Object value) {
            Type type;
            if (opcode == 18 && value instanceof Type && (type = (Type)value).getSort() == 10) {
                this.lastTwoClassConstants.add((Object)type.getClassName());
                return;
            }
            this.lastTwoClassConstants.poll();
        }
    }

    private class AdviceReferenceMethodVisitor
    extends MethodVisitor {
        private int currentLineNumber;

        public AdviceReferenceMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.currentLineNumber = -1;
        }

        public void visitLineNumber(int line, Label start) {
            this.currentLineNumber = line;
            super.visitLineNumber(line, start);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            Type ownerType = owner.startsWith("[") ? ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)owner)) : Type.getType((String)("L" + owner + ";"));
            Type fieldType = Type.getType((String)descriptor);
            ArrayList<Object> fieldFlags = new ArrayList<Object>();
            fieldFlags.add(ReferenceCollectingClassVisitor.computeMinimumFieldAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType));
            fieldFlags.add(opcode == 178 || opcode == 179 ? Flag.OwnershipFlag.STATIC : Flag.OwnershipFlag.NON_STATIC);
            ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)ownerType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType)).addField(new Source[]{new Source(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber)}, fieldFlags.toArray(new Flag[0]), name, fieldType, false).build());
            Type underlyingFieldType = ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)descriptor));
            if (underlyingFieldType.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)underlyingFieldType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, underlyingFieldType)).build());
            }
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            Type methodType = Type.getMethodType((String)descriptor);
            Type ownerType = owner.startsWith("[") ? ReferenceCollectingClassVisitor.underlyingType(Type.getType((String)owner)) : Type.getType((String)("L" + owner + ";"));
            Type[] returnType = ReferenceCollectingClassVisitor.underlyingType(methodType.getReturnType());
            if (returnType.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)returnType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, (Type)returnType)).build());
            }
            for (Type paramType : methodType.getArgumentTypes()) {
                if ((paramType = ReferenceCollectingClassVisitor.underlyingType(paramType)).getSort() != 10) continue;
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)paramType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, paramType)).build());
            }
            ArrayList<Object> methodFlags = new ArrayList<Object>();
            methodFlags.add(opcode == 184 ? Flag.OwnershipFlag.STATIC : Flag.OwnershipFlag.NON_STATIC);
            methodFlags.add(ReferenceCollectingClassVisitor.computeMinimumMethodAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType));
            ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)ownerType.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)(isInterface ? Flag.ManifestationFlag.INTERFACE : Flag.ManifestationFlag.NON_INTERFACE)).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, ownerType)).addMethod(new Source[]{new Source(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber)}, methodFlags.toArray(new Flag[0]), name, methodType.getReturnType(), methodType.getArgumentTypes()).build());
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitTypeInsn(int opcode, String type) {
            Type typeObj = ReferenceCollectingClassVisitor.underlyingType(Type.getObjectType((String)type));
            if (typeObj.getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)typeObj.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, typeObj)).build());
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)Utils.getClassName(bootstrapMethodHandle.getOwner())).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, Type.getObjectType((String)bootstrapMethodHandle.getOwner()))).build());
            for (Object arg : bootstrapMethodArguments) {
                if (!(arg instanceof Handle)) continue;
                Handle handle = (Handle)arg;
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)Utils.getClassName(handle.getOwner())).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, Type.getObjectType((String)handle.getOwner()))).build());
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        public void visitLdcInsn(Object value) {
            Type type;
            if (value instanceof Type && (type = ReferenceCollectingClassVisitor.underlyingType((Type)value)).getSort() == 10) {
                ReferenceCollectingClassVisitor.this.addReference(ClassRef.newBuilder((String)type.getClassName()).addSource(ReferenceCollectingClassVisitor.this.refSourceClassName, this.currentLineNumber).addFlag((Flag)ReferenceCollectingClassVisitor.computeMinimumClassAccess(ReferenceCollectingClassVisitor.this.refSourceType, type)).build());
            }
            super.visitLdcInsn(value);
        }
    }
}

