/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResourceBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.ReferenceMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class ClassLoaderMatcher {
    public static Map<String, List<Mismatch>> matchesAll(ClassLoader classLoader, boolean injectHelpers) {
        HashMap<String, List<Mismatch>> result = new HashMap<String, List<Mismatch>>();
        ServiceLoader.load(InstrumentationModule.class).forEach(module -> result.put(module.getClass().getName(), ClassLoaderMatcher.matches(module, classLoader, injectHelpers)));
        return result;
    }

    private static List<Mismatch> matches(InstrumentationModule instrumentationModule, ClassLoader classLoader, boolean injectHelpers) {
        List<Mismatch> mismatches = ClassLoaderMatcher.checkReferenceMatcher(instrumentationModule, classLoader);
        mismatches = ClassLoaderMatcher.checkModuleClassLoaderMatcher(instrumentationModule, classLoader, mismatches);
        if (injectHelpers) {
            mismatches = ClassLoaderMatcher.checkHelperInjection(instrumentationModule, classLoader, mismatches);
        }
        return mismatches;
    }

    private static List<Mismatch> checkReferenceMatcher(InstrumentationModule instrumentationModule, ClassLoader classLoader) {
        ReferenceMatcher muzzle = new ReferenceMatcher(instrumentationModule.getMuzzleHelperClassNames(), instrumentationModule.getMuzzleReferences(), arg_0 -> ((InstrumentationModule)instrumentationModule).isHelperClass(arg_0));
        return muzzle.getMismatchedReferenceSources(classLoader);
    }

    private static List<Mismatch> checkModuleClassLoaderMatcher(InstrumentationModule instrumentationModule, ClassLoader classLoader, List<Mismatch> mismatches) {
        if (!instrumentationModule.classLoaderMatcher().matches((Object)classLoader)) {
            mismatches = ReferenceMatcher.add(mismatches, new Mismatch.InstrumentationModuleClassLoaderMismatch());
        }
        return mismatches;
    }

    private static List<Mismatch> checkHelperInjection(InstrumentationModule instrumentationModule, ClassLoader classLoader, List<Mismatch> mismatches) {
        try {
            List allHelperClasses = instrumentationModule.getMuzzleHelperClassNames();
            HelperResourceBuilderImpl helperResourceBuilder = new HelperResourceBuilderImpl();
            List helperResourceNames = instrumentationModule.helperResourceNames();
            for (String helperResourceName : helperResourceNames) {
                helperResourceBuilder.register(helperResourceName);
            }
            instrumentationModule.registerHelperResources((HelperResourceBuilder)helperResourceBuilder);
            if (!allHelperClasses.isEmpty()) {
                new HelperInjector(instrumentationModule.instrumentationName(), allHelperClasses, helperResourceBuilder.getResources(), Thread.currentThread().getContextClassLoader(), null).transform(null, null, classLoader, null);
            }
        }
        catch (RuntimeException e) {
            mismatches = ReferenceMatcher.add(mismatches, new Mismatch.HelperClassesInjectionError());
        }
        return mismatches;
    }

    private ClassLoaderMatcher() {
    }
}

