/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import io.opentelemetry.javaagent.extension.muzzle.ClassRef;
import io.opentelemetry.javaagent.extension.muzzle.FieldRef;
import io.opentelemetry.javaagent.extension.muzzle.Flag;
import io.opentelemetry.javaagent.extension.muzzle.MethodRef;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.pool.TypePool;

interface HelperReferenceWrapper {
    public boolean isAbstract();

    public boolean hasSuperTypes();

    public Stream<HelperReferenceWrapper> getSuperTypes();

    public Stream<Method> getMethods();

    public Stream<Field> getFields();

    public static class Factory {
        private final TypePool classpathPool;
        private final Map<String, ClassRef> helperReferences;

        public Factory(TypePool classpathPool, Map<String, ClassRef> helperReferences) {
            this.classpathPool = classpathPool;
            this.helperReferences = helperReferences;
        }

        public HelperReferenceWrapper create(ClassRef reference) {
            return new ReferenceType(reference);
        }

        private HelperReferenceWrapper create(String className) {
            TypePool.Resolution resolution = this.classpathPool.describe(className);
            if (resolution.isResolved()) {
                return new ClasspathType(resolution.resolve());
            }
            if (this.helperReferences.containsKey(className)) {
                return new ReferenceType(this.helperReferences.get(className));
            }
            throw new IllegalStateException("Missing class " + className);
        }

        private static final class ClasspathType
        implements HelperReferenceWrapper {
            private final TypeDescription type;

            private ClasspathType(TypeDescription type) {
                this.type = type;
            }

            @Override
            public boolean isAbstract() {
                return this.type.isAbstract();
            }

            @Override
            public boolean hasSuperTypes() {
                return this.hasActualSuperType() || this.type.getInterfaces().size() > 0;
            }

            private boolean hasActualSuperType() {
                return this.type.getSuperClass() != null;
            }

            @Override
            public Stream<HelperReferenceWrapper> getSuperTypes() {
                Stream<Object> superClass = Stream.empty();
                if (this.hasActualSuperType()) {
                    superClass = Stream.of(new ClasspathType(this.type.getSuperClass().asErasure()));
                }
                Stream<HelperReferenceWrapper> interfaces = this.type.getInterfaces().asErasures().stream().map(ClasspathType::new);
                return Stream.concat(superClass, interfaces);
            }

            @Override
            public Stream<Method> getMethods() {
                return this.type.getDeclaredMethods().stream().filter(ClasspathType::isOverrideable).map(this::toMethod);
            }

            private static boolean isOverrideable(MethodDescription.InDefinedShape method) {
                return !method.isStatic() && !method.isPrivate() && !method.isConstructor();
            }

            private Method toMethod(MethodDescription.InDefinedShape method) {
                return new Method(method.isAbstract(), this.type.getName(), method.getInternalName(), method.getDescriptor());
            }

            @Override
            public Stream<Field> getFields() {
                return this.type.getDeclaredFields().stream().filter(ClasspathType::isNotPrivate).map(ClasspathType::toField);
            }

            private static boolean isNotPrivate(FieldDescription.InDefinedShape field) {
                return !field.isPrivate();
            }

            private static Field toField(FieldDescription.InDefinedShape field) {
                return new Field(field.getName(), field.getDescriptor());
            }
        }

        private final class ReferenceType
        implements HelperReferenceWrapper {
            private final ClassRef reference;

            private ReferenceType(ClassRef reference) {
                this.reference = reference;
            }

            @Override
            public boolean isAbstract() {
                return this.reference.getFlags().contains(Flag.ManifestationFlag.ABSTRACT);
            }

            @Override
            public boolean hasSuperTypes() {
                return this.hasActualSuperType() || this.reference.getInterfaceNames().size() > 0;
            }

            @Override
            public Stream<HelperReferenceWrapper> getSuperTypes() {
                Stream<Object> superClass = Stream.empty();
                if (this.hasActualSuperType()) {
                    superClass = Stream.of(Factory.this.create(this.reference.getSuperClassName()));
                }
                Stream<HelperReferenceWrapper> interfaces = this.reference.getInterfaceNames().stream().map(x$0 -> Factory.this.create(x$0));
                return Stream.concat(superClass, interfaces);
            }

            private boolean hasActualSuperType() {
                return this.reference.getSuperClassName() != null;
            }

            @Override
            public Stream<Method> getMethods() {
                return this.reference.getMethods().stream().filter(this::isOverrideable).map(this::toMethod);
            }

            private boolean isOverrideable(MethodRef method) {
                return !method.getFlags().contains(Flag.OwnershipFlag.STATIC) && !method.getFlags().contains(Flag.VisibilityFlag.PRIVATE) && !"<init>".equals(method.getName());
            }

            private Method toMethod(MethodRef method) {
                return new Method(method.getFlags().contains(Flag.ManifestationFlag.ABSTRACT), this.reference.getClassName(), method.getName(), method.getDescriptor());
            }

            @Override
            public Stream<Field> getFields() {
                return this.reference.getFields().stream().filter(this::isDeclaredAndNotPrivate).map(this::toField);
            }

            private boolean isDeclaredAndNotPrivate(FieldRef field) {
                return field.isDeclared() && !field.getFlags().contains(Flag.VisibilityFlag.PRIVATE);
            }

            private Field toField(FieldRef field) {
                return new Field(field.getName(), field.getDescriptor());
            }
        }
    }

    public static final class Field {
        private final String name;
        private final String descriptor;

        public Field(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return Objects.equals(this.name, field.name) && Objects.equals(this.descriptor, field.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }

        public String toString() {
            return "Field{name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + '}';
        }
    }

    public static final class Method {
        private final boolean isAbstract;
        private final String declaringClass;
        private final String name;
        private final String descriptor;

        public Method(boolean isAbstract, String declaringClass, String name, String descriptor) {
            this.isAbstract = isAbstract;
            this.declaringClass = declaringClass;
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean isAbstract() {
            return this.isAbstract;
        }

        public String getDeclaringClass() {
            return this.declaringClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Method)) {
                return false;
            }
            Method other = (Method)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.descriptor, other.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }

        public String toString() {
            return "Method{isAbstract=" + this.isAbstract + ", declaringClass='" + this.declaringClass + '\'' + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + '}';
        }
    }
}

