/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import java.util.function.Predicate;

public final class HelperClassPredicate {
    private static final String JAVAAGENT_INSTRUMENTATION_PACKAGE = "io.opentelemetry.javaagent.instrumentation.";
    private static final String JAVAAGENT_API_PACKAGE = "io.opentelemetry.javaagent.instrumentation.api.";
    private static final String LIBRARY_INSTRUMENTATION_PACKAGE = "io.opentelemetry.instrumentation.";
    private static final String INSTRUMENTATION_API_PACKAGE = "io.opentelemetry.instrumentation.api.";
    private final Predicate<String> additionalLibraryHelperClassPredicate;

    public HelperClassPredicate(Predicate<String> additionalLibraryHelperClassPredicate) {
        this.additionalLibraryHelperClassPredicate = additionalLibraryHelperClassPredicate;
    }

    public boolean isHelperClass(String className) {
        return HelperClassPredicate.isJavaagentHelperClass(className) || HelperClassPredicate.isLibraryHelperClass(className) || this.additionalLibraryHelperClassPredicate.test(className);
    }

    public boolean isLibraryClass(String className) {
        return !this.isHelperClass(className) && !HelperClassPredicate.isBootstrapClass(className);
    }

    private static boolean isBootstrapClass(String className) {
        return className.startsWith(JAVAAGENT_API_PACKAGE) || className.startsWith(INSTRUMENTATION_API_PACKAGE) || className.startsWith("io.opentelemetry.javaagent.bootstrap.") || className.startsWith("io.opentelemetry.api.") || className.startsWith("io.opentelemetry.context.") || className.startsWith("io.opentelemetry.semconv.") || className.startsWith("org.slf4j.");
    }

    private static boolean isJavaagentHelperClass(String className) {
        return className.startsWith(JAVAAGENT_INSTRUMENTATION_PACKAGE) && !className.startsWith(JAVAAGENT_API_PACKAGE);
    }

    private static boolean isLibraryHelperClass(String className) {
        return className.startsWith(LIBRARY_INSTRUMENTATION_PACKAGE) && !className.startsWith(INSTRUMENTATION_API_PACKAGE);
    }
}

