/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.FieldRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.MethodRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ServiceLoader;

public final class ReferencesPrinter {
    private static final String INDENT = "  ";

    public static void printMuzzleReferences() {
        for (InstrumentationModule instrumentationModule : ServiceLoader.load(InstrumentationModule.class)) {
            try {
                System.out.println(instrumentationModule.getClass().getName());
                for (ClassRef ref : InstrumentationModuleMuzzle.getMuzzleReferences(instrumentationModule).values()) {
                    System.out.print(ReferencesPrinter.prettyPrint(ref));
                }
            }
            catch (RuntimeException e) {
                String message = "Unexpected exception printing references for " + instrumentationModule.getClass().getName();
                System.out.println(message);
                throw new IllegalStateException(message, e);
            }
        }
    }

    private static String prettyPrint(ClassRef ref) {
        StringBuilder builder = new StringBuilder(INDENT).append(ref).append(System.lineSeparator());
        if (!ref.getSources().isEmpty()) {
            builder.append(INDENT).append(INDENT).append("Sources:").append(System.lineSeparator());
            for (Source source : ref.getSources()) {
                builder.append(INDENT).append(INDENT).append(INDENT).append("at: ").append(source).append(System.lineSeparator());
            }
        }
        for (FieldRef field : ref.getFields()) {
            builder.append(INDENT).append(INDENT).append(field).append(System.lineSeparator());
        }
        for (MethodRef method : ref.getMethods()) {
            builder.append(INDENT).append(INDENT).append(method).append(System.lineSeparator());
        }
        return builder.toString();
    }

    private ReferencesPrinter() {
    }
}

