/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.references;

import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.FieldRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.MethodRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public final class ClassRefBuilder {
    static final boolean COLLECT_SOURCES = true;
    private final Set<Source> sources = new LinkedHashSet<Source>();
    private final Set<Flag> flags = new LinkedHashSet<Flag>();
    private final String className;
    private final Set<String> interfaceNames = new LinkedHashSet<String>();
    private final List<FieldRef> fields = new ArrayList<FieldRef>();
    private final List<MethodRef> methods = new ArrayList<MethodRef>();
    @Nullable
    private String superClassName = null;

    ClassRefBuilder(String className) {
        this.className = className;
    }

    public ClassRefBuilder setSuperClassName(String superName) {
        this.superClassName = superName;
        return this;
    }

    public ClassRefBuilder addInterfaceNames(Collection<String> interfaceNames) {
        this.interfaceNames.addAll(interfaceNames);
        return this;
    }

    public ClassRefBuilder addInterfaceName(String interfaceName) {
        this.interfaceNames.add(interfaceName);
        return this;
    }

    public ClassRefBuilder addSource(String sourceName) {
        return this.addSource(sourceName, 0);
    }

    public ClassRefBuilder addSource(String sourceName, int line) {
        this.sources.add(new Source(sourceName, line));
        return this;
    }

    public ClassRefBuilder addFlag(Flag flag) {
        this.flags.add(flag);
        return this;
    }

    public ClassRefBuilder addField(Source[] fieldSources, Flag[] fieldFlags, String fieldName, Type fieldType, boolean isFieldDeclared) {
        FieldRef field = new FieldRef(new LinkedHashSet<Source>(Arrays.asList(fieldSources)), new LinkedHashSet<Flag>(Arrays.asList(fieldFlags)), fieldName, fieldType.getDescriptor(), isFieldDeclared);
        int existingIndex = this.fields.indexOf(field);
        if (existingIndex == -1) {
            this.fields.add(field);
        } else {
            this.fields.set(existingIndex, field.merge(this.fields.get(existingIndex)));
        }
        return this;
    }

    public ClassRefBuilder addMethod(Source[] methodSources, Flag[] methodFlags, String methodName, Type methodReturnType, Type ... methodArgumentTypes) {
        MethodRef method = new MethodRef(new LinkedHashSet<Source>(Arrays.asList(methodSources)), new LinkedHashSet<Flag>(Arrays.asList(methodFlags)), methodName, Type.getMethodDescriptor((Type)methodReturnType, (Type[])methodArgumentTypes));
        int existingIndex = this.methods.indexOf(method);
        if (existingIndex == -1) {
            this.methods.add(method);
        } else {
            this.methods.set(existingIndex, method.merge(this.methods.get(existingIndex)));
        }
        return this;
    }

    public ClassRef build() {
        return new ClassRef(this.sources, this.flags, this.className, this.superClassName, this.interfaceNames, new LinkedHashSet<FieldRef>(this.fields), new LinkedHashSet<MethodRef>(this.methods));
    }
}

