/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.references;

import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.ReferenceMergeUtil;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.lang.invoke.LambdaMetafactory;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public final class FieldRef {
    private final Set<Source> sources;
    private final Set<Flag> flags;
    private final String name;
    private final String descriptor;
    private final boolean declared;

    FieldRef(Set<Source> sources, Set<Flag> flags, String name, String descriptor, boolean declared) {
        this.sources = sources;
        this.flags = flags;
        this.name = name;
        this.descriptor = descriptor;
        this.declared = declared;
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    FieldRef merge(FieldRef anotherField) {
        if (!this.equals(anotherField) || !this.descriptor.equals(anotherField.descriptor)) {
            throw new IllegalStateException("illegal merge " + this + " != " + anotherField);
        }
        return new FieldRef(ReferenceMergeUtil.mergeSet(this.sources, anotherField.sources), ReferenceMergeUtil.mergeFlags(this.flags, anotherField.flags), this.name, this.descriptor, this.declared || anotherField.declared);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldRef)) {
            return false;
        }
        FieldRef other = (FieldRef)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String modifiers = this.flags.stream().map((Function<Flag, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/opentelemetry/javaagent/tooling/muzzle/references/Flag;)Ljava/lang/String;)()).collect(Collectors.joining(" "));
        String fieldType = Type.getType((String)this.getDescriptor()).getClassName();
        return this.getClass().getSimpleName() + ": " + modifiers + " " + fieldType + " " + this.name;
    }
}

