/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.test.utils;

import io.opentelemetry.instrumentation.test.utils.PortAllocator;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public final class PortUtils {
    public static final int UNUSABLE_PORT = 61;
    private static final PortAllocator portAllocator = new PortAllocator();

    public static int findOpenPorts(int count) {
        return portAllocator.getPorts(count);
    }

    public static int findOpenPort() {
        return portAllocator.getPort();
    }

    private static boolean isPortOpen(int port) {
        boolean bl;
        Socket socket = new Socket((String)null, port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public static void waitForPortToOpen(int port, long timeout, TimeUnit unit) {
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < waitUntil) {
            if (PortUtils.isPortOpen(port)) {
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for " + port + " to be opened");
            }
        }
        throw new IllegalStateException("Timed out waiting for port " + port + " to be opened");
    }

    public static void waitForPortToOpen(int port, long timeout, TimeUnit unit, Process process) {
        long waitUntil = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < waitUntil) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while waiting for " + port + " to be opened");
            }
            try {
                process.exitValue();
                throw new IllegalStateException("Process died before port " + port + " was opened");
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (!PortUtils.isPortOpen(port)) continue;
                return;
            }
        }
        throw new IllegalStateException("Timed out waiting for port " + port + " to be opened");
    }

    private PortUtils() {
    }
}

