/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.instrumentation.testing.junit.InstrumentationExtension;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.LongSumAssert;
import io.opentelemetry.sdk.testing.assertj.MetricAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.util.function.Consumer;

public final class DbConnectionPoolMetricsAssertions {
    private static final AttributeKey<String> POOL_NAME_KEY = AttributeKey.stringKey((String)"pool.name");
    private static final AttributeKey<String> STATE_KEY = AttributeKey.stringKey((String)"state");
    private final InstrumentationExtension testing;
    private final String instrumentationName;
    private final String poolName;
    private boolean testMinIdleConnections = true;
    private boolean testMaxIdleConnections = true;
    private boolean testMaxConnections = true;
    private boolean testPendingRequests = true;
    private boolean testConnectionTimeouts = true;
    private boolean testCreateTime = true;
    private boolean testWaitTime = true;
    private boolean testUseTime = true;

    public static DbConnectionPoolMetricsAssertions create(InstrumentationExtension testing, String instrumentationName, String poolName) {
        return new DbConnectionPoolMetricsAssertions(testing, instrumentationName, poolName);
    }

    DbConnectionPoolMetricsAssertions(InstrumentationExtension testing, String instrumentationName, String poolName) {
        this.testing = testing;
        this.instrumentationName = instrumentationName;
        this.poolName = poolName;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disableMinIdleConnections() {
        this.testMinIdleConnections = false;
        return this;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disableMaxIdleConnections() {
        this.testMaxIdleConnections = false;
        return this;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disableMaxConnections() {
        this.testMaxConnections = false;
        return this;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disablePendingRequests() {
        this.testPendingRequests = false;
        return this;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disableConnectionTimeouts() {
        this.testConnectionTimeouts = false;
        return this;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disableCreateTime() {
        this.testCreateTime = false;
        return this;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disableWaitTime() {
        this.testWaitTime = false;
        return this;
    }

    @CanIgnoreReturnValue
    public DbConnectionPoolMetricsAssertions disableUseTime() {
        this.testUseTime = false;
        return this;
    }

    public void assertConnectionPoolEmitsMetrics() {
        this.verifyConnectionUsage();
        if (this.testMinIdleConnections) {
            this.verifyMinIdleConnections();
        }
        if (this.testMaxIdleConnections) {
            this.verifyMaxIdleConnections();
        }
        if (this.testMaxConnections) {
            this.verifyMaxConnections();
        }
        if (this.testPendingRequests) {
            this.verifyPendingRequests();
        }
        if (this.testConnectionTimeouts) {
            this.verifyTimeouts();
        }
        if (this.testCreateTime) {
            this.verifyCreateTime();
        }
        if (this.testWaitTime) {
            this.verifyWaitTime();
        }
        if (this.testUseTime) {
            this.verifyUseTime();
        }
    }

    private void verifyConnectionUsage() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.usage", metrics -> metrics.anySatisfy(this::verifyUsageMetric));
    }

    private void verifyUsageMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("{connections}").hasDescription("The number of connections that are currently in state described by the state attribute.").hasLongSumSatisfying(sum -> sum.isNotMonotonic().hasPointsSatisfying(new Consumer[]{point -> point.hasAttributesSatisfying(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo(POOL_NAME_KEY, (Object)this.poolName), OpenTelemetryAssertions.equalTo(STATE_KEY, (Object)"idle")}), point -> point.hasAttributesSatisfying(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo(POOL_NAME_KEY, (Object)this.poolName), OpenTelemetryAssertions.equalTo(STATE_KEY, (Object)"used")})}));
    }

    private void verifyMaxConnections() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.max", metrics -> metrics.anySatisfy(this::verifyMaxConnectionsMetric));
    }

    private void verifyMaxConnectionsMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("{connections}").hasDescription("The maximum number of open connections allowed.").hasLongSumSatisfying(this::verifyPoolName);
    }

    private void verifyMinIdleConnections() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.idle.min", metrics -> metrics.anySatisfy(this::verifyMinIdleConnectionsMetric));
    }

    private void verifyMinIdleConnectionsMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("{connections}").hasDescription("The minimum number of idle open connections allowed.").hasLongSumSatisfying(this::verifyPoolName);
    }

    private void verifyMaxIdleConnections() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.idle.max", metrics -> metrics.anySatisfy(this::verifyMaxIdleConnectionsMetric));
    }

    private void verifyMaxIdleConnectionsMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("{connections}").hasDescription("The maximum number of idle open connections allowed.").hasLongSumSatisfying(this::verifyPoolName);
    }

    private void verifyPoolName(LongSumAssert sum) {
        sum.isNotMonotonic().hasPointsSatisfying(new Consumer[]{point -> point.hasAttributes(Attributes.of(POOL_NAME_KEY, (Object)this.poolName))});
    }

    private void verifyPendingRequests() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.pending_requests", metrics -> metrics.anySatisfy(this::verifyPendingRequestsMetric));
    }

    private void verifyPendingRequestsMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("{requests}").hasDescription("The number of pending requests for an open connection, cumulative for the entire pool.").hasLongSumSatisfying(this::verifyPoolName);
    }

    private void verifyTimeouts() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.timeouts", metrics -> metrics.anySatisfy(this::verifyTimeoutsMetric));
    }

    private void verifyTimeoutsMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("{timeouts}").hasDescription("The number of connection timeouts that have occurred trying to obtain a connection from the pool.").hasLongSumSatisfying(sum -> sum.isMonotonic().hasPointsSatisfying(new Consumer[]{point -> point.hasAttributes(Attributes.of(POOL_NAME_KEY, (Object)this.poolName))}));
    }

    private void verifyCreateTime() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.create_time", metrics -> metrics.anySatisfy(this::verifyCreateTimeMetric));
    }

    private void verifyCreateTimeMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("ms").hasDescription("The time it took to create a new connection.").hasHistogramSatisfying(histogram -> histogram.hasPointsSatisfying(new Consumer[]{point -> point.hasAttributes(Attributes.of(POOL_NAME_KEY, (Object)this.poolName))}));
    }

    private void verifyWaitTime() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.wait_time", metrics -> metrics.anySatisfy(this::verifyWaitTimeMetric));
    }

    private void verifyWaitTimeMetric(MetricData metric) {
        OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("ms").hasDescription("The time it took to obtain an open connection from the pool.").hasHistogramSatisfying(histogram -> histogram.hasPointsSatisfying(new Consumer[]{point -> point.hasAttributes(Attributes.of(POOL_NAME_KEY, (Object)this.poolName))}));
    }

    private void verifyUseTime() {
        this.testing.waitAndAssertMetrics(this.instrumentationName, "db.client.connections.use_time", metrics -> metrics.anySatisfy(this::verifyUseTimeMetric));
    }

    private MetricAssert verifyUseTimeMetric(MetricData metric) {
        return OpenTelemetryAssertions.assertThat((MetricData)metric).hasUnit("ms").hasDescription("The time between borrowing a connection and returning it to the pool.").hasHistogramSatisfying(histogram -> histogram.hasPointsSatisfying(new Consumer[]{point -> point.hasAttributes(Attributes.of(POOL_NAME_KEY, (Object)this.poolName))}));
    }
}

