/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.testing.junit.http.AutoValue_HttpClientTestOptions;
import io.opentelemetry.instrumentation.testing.junit.http.SemconvStabilityUtil;
import io.opentelemetry.instrumentation.testing.junit.http.SingleConnection;
import io.opentelemetry.semconv.SemanticAttributes;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

@AutoValue
public abstract class HttpClientTestOptions {
    public static final Set<AttributeKey<?>> DEFAULT_HTTP_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<AttributeKey>(Arrays.asList(SemconvStabilityUtil.getAttributeKey(SemanticAttributes.NET_PROTOCOL_VERSION), SemconvStabilityUtil.getAttributeKey(SemanticAttributes.NET_PEER_NAME), SemconvStabilityUtil.getAttributeKey(SemanticAttributes.NET_PEER_PORT), SemconvStabilityUtil.getAttributeKey(SemanticAttributes.HTTP_URL), SemconvStabilityUtil.getAttributeKey(SemanticAttributes.HTTP_METHOD))));
    public static final BiFunction<URI, String, String> DEFAULT_EXPECTED_CLIENT_SPAN_NAME_MAPPER = (uri, method) -> "_OTHER".equals(method) ? "HTTP" : method;
    public static final int FOUND_STATUS_CODE = HttpStatus.FOUND.code();

    public abstract Function<URI, Set<AttributeKey<?>>> getHttpAttributes();

    @Nullable
    public abstract Integer getResponseCodeOnRedirectError();

    public abstract BiFunction<URI, Throwable, Throwable> getClientSpanErrorMapper();

    public abstract BiFunction<String, Integer, SingleConnection> getSingleConnectionFactory();

    public abstract BiFunction<URI, String, String> getExpectedClientSpanNameMapper();

    abstract HttpClientInstrumentationType getInstrumentationType();

    public boolean isLowLevelInstrumentation() {
        return this.getInstrumentationType() == HttpClientInstrumentationType.LOW_LEVEL;
    }

    public abstract boolean getTestWithClientParent();

    public abstract boolean getTestRedirects();

    public abstract boolean getTestCircularRedirects();

    public abstract int getMaxRedirects();

    public abstract boolean getTestReusedRequest();

    public abstract boolean getTestConnectionFailure();

    public abstract boolean getTestReadTimeout();

    public abstract boolean getTestRemoteConnection();

    public abstract boolean getTestHttps();

    public abstract boolean getTestCallback();

    public abstract boolean getTestCallbackWithParent();

    public abstract boolean getTestErrorWithCallback();

    public abstract boolean getTestNonStandardHttpMethod();

    static Builder builder() {
        return new AutoValue_HttpClientTestOptions.Builder().withDefaults();
    }

    static enum HttpClientInstrumentationType {
        LOW_LEVEL,
        HIGH_LEVEL;

    }

    @AutoValue.Builder
    public static interface Builder {
        @CanIgnoreReturnValue
        default public Builder withDefaults() {
            return this.setHttpAttributes(x -> DEFAULT_HTTP_ATTRIBUTES).setResponseCodeOnRedirectError(FOUND_STATUS_CODE).setClientSpanErrorMapper((uri, exception) -> exception).setSingleConnectionFactory((host, port) -> null).setExpectedClientSpanNameMapper(DEFAULT_EXPECTED_CLIENT_SPAN_NAME_MAPPER).setInstrumentationType(HttpClientInstrumentationType.HIGH_LEVEL).setTestWithClientParent(true).setTestRedirects(true).setTestCircularRedirects(true).setMaxRedirects(2).setTestReusedRequest(true).setTestConnectionFailure(true).setTestReadTimeout(true).setTestRemoteConnection(true).setTestHttps(true).setTestCallback(true).setTestCallbackWithParent(true).setTestErrorWithCallback(true).setTestNonStandardHttpMethod(true);
        }

        public Builder setHttpAttributes(Function<URI, Set<AttributeKey<?>>> var1);

        public Builder setResponseCodeOnRedirectError(Integer var1);

        public Builder setClientSpanErrorMapper(BiFunction<URI, Throwable, Throwable> var1);

        public Builder setSingleConnectionFactory(BiFunction<String, Integer, SingleConnection> var1);

        public Builder setExpectedClientSpanNameMapper(BiFunction<URI, String, String> var1);

        public Builder setInstrumentationType(HttpClientInstrumentationType var1);

        public Builder setTestWithClientParent(boolean var1);

        public Builder setTestRedirects(boolean var1);

        public Builder setTestCircularRedirects(boolean var1);

        public Builder setMaxRedirects(int var1);

        public Builder setTestReusedRequest(boolean var1);

        public Builder setTestConnectionFailure(boolean var1);

        public Builder setTestReadTimeout(boolean var1);

        public Builder setTestRemoteConnection(boolean var1);

        public Builder setTestHttps(boolean var1);

        public Builder setTestCallback(boolean var1);

        public Builder setTestCallbackWithParent(boolean var1);

        public Builder setTestErrorWithCallback(boolean var1);

        public Builder setTestNonStandardHttpMethod(boolean var1);

        @CanIgnoreReturnValue
        default public Builder disableTestWithClientParent() {
            return this.setTestWithClientParent(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestRedirects() {
            return this.setTestRedirects(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestCircularRedirects() {
            return this.setTestCircularRedirects(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestReusedRequest() {
            return this.setTestReusedRequest(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestConnectionFailure() {
            return this.setTestConnectionFailure(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestReadTimeout() {
            return this.setTestReadTimeout(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestRemoteConnection() {
            return this.setTestRemoteConnection(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestHttps() {
            return this.setTestHttps(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestCallback() {
            return this.setTestCallback(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestCallbackWithParent() {
            return this.setTestCallbackWithParent(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestErrorWithCallback() {
            return this.setTestErrorWithCallback(false);
        }

        @CanIgnoreReturnValue
        default public Builder disableTestNonStandardHttpMethod() {
            return this.setTestNonStandardHttpMethod(false);
        }

        @CanIgnoreReturnValue
        default public Builder markAsLowLevelInstrumentation() {
            return this.setInstrumentationType(HttpClientInstrumentationType.LOW_LEVEL);
        }

        public HttpClientTestOptions build();
    }
}

