/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.test.server.http.RequestContextGetter;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServerBuilder;
import io.opentelemetry.testing.internal.armeria.server.logging.LoggingService;
import io.opentelemetry.testing.internal.armeria.testing.junit5.server.ServerExtension;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.time.Duration;
import javax.net.ssl.KeyManagerFactory;

public final class HttpClientTestServer
extends ServerExtension {
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    public HttpClientTestServer(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        this.tracer = openTelemetry.getTracer("test");
    }

    @Override
    protected void configure(ServerBuilder sb) throws Exception {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        try (InputStream in = Files.newInputStream(Paths.get(System.getProperty("javax.net.ssl.trustStore"), new String[0]), new OpenOption[0]);){
            keystore.load(in, "testing".toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, "testing".toCharArray());
        sb.http(0).https(0).tls(kmf).idleTimeout(Duration.ofSeconds(60L)).service("/success", (ctx, req) -> {
            String capturedHeader;
            ResponseHeadersBuilder headers = ResponseHeaders.builder(HttpStatus.OK);
            String testRequestId = req.headers().get("test-request-id");
            if (testRequestId != null) {
                headers.set((CharSequence)"test-request-id", testRequestId);
            }
            if ((capturedHeader = req.headers().get("X-Test-Request")) != null) {
                headers.set((CharSequence)"X-Test-Response", capturedHeader);
            }
            return HttpResponse.of(headers.build(), HttpData.ofAscii("Hello."));
        }).service("/client-error", (ctx, req) -> HttpResponse.of(HttpStatus.BAD_REQUEST, MediaType.PLAIN_TEXT_UTF_8, "Invalid RQ")).service("/error", (ctx, req) -> HttpResponse.of(HttpStatus.INTERNAL_SERVER_ERROR, MediaType.PLAIN_TEXT_UTF_8, "Sorry.")).service("/redirect", (ctx, req) -> HttpResponse.ofRedirect(HttpStatus.FOUND, "/success")).service("/another-redirect", (ctx, req) -> HttpResponse.ofRedirect(HttpStatus.FOUND, "/redirect")).service("/circular-redirect", (ctx, req) -> HttpResponse.ofRedirect(HttpStatus.FOUND, "/circular-redirect")).service("/secured", (ctx, req) -> {
            String auth = req.headers().get("custom-authorization-header");
            if (auth != null && auth.equals("plain text auth token")) {
                return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT_UTF_8, "secured string under basic auth");
            }
            return HttpResponse.of(HttpStatus.UNAUTHORIZED, MediaType.PLAIN_TEXT_UTF_8, "Unauthorized");
        }).service("/to-secured", (ctx, req) -> HttpResponse.ofRedirect(HttpStatus.FOUND, "/secured")).service("/read-timeout", (ctx, req) -> HttpResponse.delayed(HttpResponse.of(HttpStatus.OK), Duration.ofSeconds(20L))).decorator((delegate, ctx, req) -> {
            for (String field : this.openTelemetry.getPropagators().getTextMapPropagator().fields()) {
                if (req.headers().getAll(field).size() > 1) {
                    throw new AssertionError((Object)("more than one " + field + " header present"));
                }
            }
            SpanBuilder span = this.tracer.spanBuilder("test-http-server").setSpanKind(SpanKind.SERVER).setParent(this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)ctx, (TextMapGetter)RequestContextGetter.INSTANCE));
            String traceRequestId = req.headers().get("test-request-id");
            if (traceRequestId != null) {
                span.setAttribute("test.request.id", (long)Integer.parseInt(traceRequestId));
            }
            span.startSpan().end();
            return delegate.serve(ctx, req);
        }).decorator(LoggingService.newDecorator());
    }

    public URI resolveAddress(String path) {
        return URI.create("http://localhost:" + this.httpPort() + path);
    }

    public URI resolveHttpsAddress(String path) {
        return URI.create("https://localhost:" + this.httpsPort() + path);
    }
}

