/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.HashMap;
import java.util.Map;

public class SemconvStabilityUtil {
    private static final Map<AttributeKey<?>, AttributeKey<?>> oldToNewMap = new HashMap();

    private SemconvStabilityUtil() {
    }

    private static <T> void addKey(Map<AttributeKey<?>, AttributeKey<?>> map, AttributeKey<T> oldKey, AttributeKey<T> newKey) {
        map.put(oldKey, newKey);
    }

    public static <T> AttributeKey<T> getAttributeKey(AttributeKey<T> oldKey) {
        if (SemconvStability.emitStableHttpSemconv()) {
            return oldToNewMap.get(oldKey);
        }
        return oldKey;
    }

    static {
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_PROTOCOL_NAME, SemanticAttributes.NETWORK_PROTOCOL_NAME);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_PROTOCOL_VERSION, SemanticAttributes.NETWORK_PROTOCOL_VERSION);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_PEER_NAME, SemanticAttributes.SERVER_ADDRESS);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_PEER_PORT, SemanticAttributes.SERVER_PORT);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_SOCK_PEER_ADDR, NetworkAttributes.NETWORK_PEER_ADDRESS);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_SOCK_PEER_PORT, NetworkAttributes.NETWORK_PEER_PORT);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.HTTP_URL, SemanticAttributes.URL_FULL);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.HTTP_METHOD, SemanticAttributes.HTTP_REQUEST_METHOD);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.HTTP_STATUS_CODE, SemanticAttributes.HTTP_RESPONSE_STATUS_CODE);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_HOST_NAME, SemanticAttributes.SERVER_ADDRESS);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.NET_HOST_PORT, SemanticAttributes.SERVER_PORT);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.HTTP_CLIENT_IP, SemanticAttributes.CLIENT_ADDRESS);
        SemconvStabilityUtil.addKey(oldToNewMap, SemanticAttributes.HTTP_SCHEME, SemanticAttributes.URL_SCHEME);
    }
}

