/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseWrapper;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.client.WriteTimeoutException;
import io.opentelemetry.testing.internal.armeria.common.ClosedSessionException;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseCompleteException;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogBuilder;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientRequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.client.ClosedStreamExceptionUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.client.HttpSession;
import io.opentelemetry.testing.internal.armeria.internal.common.HttpHeadersUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.unsafe.PooledObjects;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFutureListener;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Error;
import io.opentelemetry.testing.internal.io.netty.handler.proxy.ProxyConnectException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpRequestHandler
implements ChannelFutureListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpRequestHandler.class);
    private final Channel ch;
    private final ClientHttpObjectEncoder encoder;
    private final HttpResponseDecoder responseDecoder;
    private final DecodedHttpResponse originalRes;
    private final ClientRequestContext ctx;
    private final RequestLogBuilder logBuilder;
    private final long timeoutMillis;
    private final boolean headersOnly;
    private final boolean allowTrailers;
    private final boolean keepAlive;
    @Nullable
    private HttpSession session;
    private int id = -1;
    @Nullable
    private HttpResponseWrapper responseWrapper;
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    private State state = State.NEEDS_TO_WRITE_FIRST_HEADER;
    private boolean loggedRequestFirstBytesTransferred;

    AbstractHttpRequestHandler(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis, boolean headersOnly, boolean allowTrailers, boolean keepAlive) {
        this.ch = ch;
        this.encoder = encoder;
        this.responseDecoder = responseDecoder;
        this.originalRes = originalRes;
        this.ctx = ctx;
        this.logBuilder = ctx.logBuilder();
        this.timeoutMillis = timeoutMillis;
        this.headersOnly = headersOnly;
        this.allowTrailers = allowTrailers;
        this.keepAlive = keepAlive;
    }

    abstract void onWriteSuccess();

    abstract void cancel();

    final Channel channel() {
        return this.ch;
    }

    final int id() {
        return this.id;
    }

    final State state() {
        return this.state;
    }

    @Override
    public final void operationComplete(ChannelFuture future) throws Exception {
        this.cancelTimeout();
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            if (future.isSuccess()) {
                if (!this.loggedRequestFirstBytesTransferred) {
                    this.logBuilder.requestFirstBytesTransferred();
                    this.loggedRequestFirstBytesTransferred = true;
                }
                if (this.state == State.DONE) {
                    this.logBuilder.endRequest();
                    assert (this.responseWrapper != null);
                    this.responseWrapper.initTimeout();
                }
                this.onWriteSuccess();
                return;
            }
            if (!this.loggedRequestFirstBytesTransferred) {
                this.fail(UnprocessedRequestException.of(future.cause()));
            } else {
                this.failAndReset(future.cause());
            }
        }
    }

    final boolean tryInitialize() {
        HttpSession session = HttpSession.get(this.ch);
        this.id = session.incrementAndGetNumRequestsSent();
        if (this.id >= 0x20000000 || !session.canSendRequest()) {
            ClosedSessionException exception = this.id >= 0x20000000 ? new ClosedSessionException("Can't send requests more than 536870912 in one connection. ID: " + this.id) : new ClosedSessionException("Can't send requests. ID: " + this.id + ", session active: " + session.isAcquirable(this.responseDecoder.keepAliveHandler()));
            session.markUnacquirable();
            this.fail(UnprocessedRequestException.of(exception));
            return false;
        }
        this.session = session;
        this.responseWrapper = this.responseDecoder.addResponse(this.id, this.originalRes, this.ctx, this.ch.eventLoop());
        if (this.timeoutMillis > 0L) {
            this.timeoutFuture = this.ch.eventLoop().schedule(() -> this.failAndReset(WriteTimeoutException.get()), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    final void writeHeaders(RequestHeaders headers) {
        SessionProtocol protocol = this.session.protocol();
        assert (protocol != null);
        this.state = this.headersOnly ? State.DONE : (this.allowTrailers ? State.NEEDS_DATA_OR_TRAILERS : State.NEEDS_DATA);
        ClientRequestContextExtension ctxExtension = this.ctx.as(ClientRequestContextExtension.class);
        HttpHeaders internalHeaders = ctxExtension == null ? HttpHeaders.of() : ctxExtension.internalRequestHeaders();
        RequestHeaders merged = HttpHeadersUtil.mergeRequestHeaders(headers, this.ctx.defaultRequestHeaders(), this.ctx.additionalRequestHeaders(), internalHeaders);
        this.logBuilder.requestHeaders(merged);
        String connectionOption = headers.get(HttpHeaderNames.CONNECTION);
        if (HttpHeadersUtil.CLOSE_STRING.equalsIgnoreCase(connectionOption) || !this.keepAlive) {
            this.session.markUnacquirable();
        }
        ChannelPromise promise = this.ch.newPromise();
        promise.addListener(this);
        this.encoder.writeHeaders(this.id, this.streamId(), merged, this.headersOnly, promise);
    }

    final void writeData(HttpData data) {
        data.touch(this.ctx);
        this.logBuilder.increaseRequestLength(data);
        this.write(data, data.isEndOfStream());
    }

    final void writeTrailers(HttpHeaders trailers) {
        this.logBuilder.requestTrailers(trailers);
        this.write(trailers, true);
    }

    private void write(HttpObject o, boolean endOfStream) {
        if (!this.ch.isActive()) {
            PooledObjects.close(o);
            this.fail(ClosedStreamExceptionUtil.newClosedSessionException(this.ch));
            return;
        }
        if (endOfStream) {
            this.state = State.DONE;
        }
        if (this.isStreamOrSessionClosed()) {
            PooledObjects.close(o);
            return;
        }
        ChannelFuture future = o instanceof HttpHeaders ? this.encoder.writeTrailers(this.id, this.streamId(), (HttpHeaders)o) : this.encoder.writeData(this.id, this.streamId(), (HttpData)o, endOfStream);
        future.addListener(this);
    }

    private boolean isStreamOrSessionClosed() {
        if (!this.encoder.isWritable(this.id, this.streamId())) {
            if (this.ctx.sessionProtocol().isMultiplex()) {
                this.failAndReset(ClosedStreamExceptionUtil.newClosedStreamException(this.ch));
            } else {
                this.failAndReset(ClosedStreamExceptionUtil.newClosedSessionException(this.ch));
            }
            return true;
        }
        return false;
    }

    private int streamId() {
        return (this.id << 1) + 1;
    }

    final void failRequest(Throwable cause) {
        if (this.id() >= 0) {
            this.failAndReset(cause);
        } else {
            this.fail(UnprocessedRequestException.of(cause));
        }
    }

    private void fail(Throwable cause) {
        this.state = State.DONE;
        this.cancel();
        this.logBuilder.endRequest(cause);
        if (this.responseWrapper != null) {
            if (this.responseWrapper.isOpen()) {
                this.responseWrapper.close(cause);
            } else {
                this.logBuilder.endResponse(cause);
            }
        } else {
            this.logBuilder.endResponse(cause);
            this.originalRes.close(cause);
        }
    }

    final void failAndReset(Throwable cause) {
        if (cause instanceof WriteTimeoutException) {
            HttpSession session = HttpSession.get(this.ch);
            session.markUnacquirable();
        }
        if (cause instanceof ProxyConnectException || cause instanceof ResponseCompleteException) {
            this.state = State.DONE;
            this.cancel();
            this.logBuilder.endRequest(cause);
            return;
        }
        this.fail(cause);
        Http2Error error = Exceptions.isStreamCancelling(cause) ? Http2Error.CANCEL : Http2Error.INTERNAL_ERROR;
        if (error.code() != Http2Error.CANCEL.code()) {
            Exceptions.logIfUnexpected(logger, this.ch, HttpSession.get(this.ch).protocol(), "a request publisher raised an exception", cause);
        }
        if (this.ch.isActive()) {
            this.encoder.writeReset(this.id, this.streamId(), error, false);
            this.ch.flush();
        }
    }

    final boolean cancelTimeout() {
        ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture == null) {
            return true;
        }
        this.timeoutFuture = null;
        return timeoutFuture.cancel(false);
    }

    static enum State {
        NEEDS_TO_WRITE_FIRST_HEADER,
        NEEDS_DATA,
        NEEDS_DATA_OR_TRAILERS,
        DONE;

    }
}

