/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.Http1ClientKeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.common.Http1HeaderNaming;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.Http1ObjectEncoder;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.DefaultHttpRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaderValues;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpMessage;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpMethod;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpObject;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpUtil;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;

final class ClientHttp1ObjectEncoder
extends Http1ObjectEncoder
implements ClientHttpObjectEncoder {
    private final Http1HeaderNaming http1HeaderNaming;
    private final KeepAliveHandler keepAliveHandler;
    private final boolean webSocket;

    ClientHttp1ObjectEncoder(Channel ch, SessionProtocol protocol, Http1HeaderNaming http1HeaderNaming, KeepAliveHandler keepAliveHandler, boolean webSocket) {
        super(ch, protocol);
        this.http1HeaderNaming = http1HeaderNaming;
        this.keepAliveHandler = keepAliveHandler;
        this.webSocket = webSocket;
    }

    @Override
    public ChannelFuture doWriteHeaders(int id, int streamId, RequestHeaders headers, boolean endStream, ChannelPromise promise) {
        return this.writeNonInformationalHeaders(id, this.convertHeaders(headers, endStream), endStream, promise);
    }

    private HttpObject convertHeaders(RequestHeaders headers, boolean endStream) {
        String method = headers.method().name();
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf(method), headers.path(), false);
        HttpHeaders nettyHeaders = req.headers();
        ArmeriaHttpUtil.toNettyHttp1ClientHeaders(headers, nettyHeaders, this.http1HeaderNaming);
        if (!nettyHeaders.contains(HttpHeaderNames.HOST)) {
            InetSocketAddress remoteAddress = (InetSocketAddress)this.channel().remoteAddress();
            nettyHeaders.add((CharSequence)HttpHeaderNames.HOST, (Object)ArmeriaHttpUtil.authorityHeader(remoteAddress.getHostString(), remoteAddress.getPort(), this.protocol().defaultPort()));
        }
        if (this.webSocket) {
            nettyHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
            nettyHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
            return req;
        }
        if (endStream) {
            nettyHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
            switch (method) {
                case "POST": 
                case "PUT": 
                case "PATCH": {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
                    break;
                }
                default: {
                    nettyHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
                    break;
                }
            }
        } else if (HttpUtil.getContentLength((HttpMessage)req, -1L) >= 0L) {
            nettyHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
        } else {
            nettyHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        return req;
    }

    @Override
    protected ChannelFuture write(HttpObject obj, ChannelPromise promise) {
        return this.channel().write(obj, promise);
    }

    @Override
    protected void convertTrailers(io.opentelemetry.testing.internal.armeria.common.HttpHeaders inputHeaders, HttpHeaders outputHeaders) {
        ArmeriaHttpUtil.toNettyHttp1ClientTrailers(inputHeaders, outputHeaders, this.http1HeaderNaming);
    }

    @Override
    public KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    @Override
    protected boolean isPing(int id) {
        KeepAliveHandler keepAliveHandler = this.keepAliveHandler();
        return keepAliveHandler instanceof Http1ClientKeepAliveHandler && ((Http1ClientKeepAliveHandler)keepAliveHandler).isPing(id);
    }
}

