/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientFactory;
import io.opentelemetry.testing.internal.armeria.client.ClientOptionValue;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContextCaptor;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientThreadLocalState;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.net.URI;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Clients {
    public static <T> T newClient(String uri, Class<T> clientType) {
        return Clients.builder(uri).build(clientType);
    }

    public static <T> T newClient(URI uri, Class<T> clientType) {
        return Clients.builder(uri).build(clientType);
    }

    public static <T> T newClient(String scheme, EndpointGroup endpointGroup, Class<T> clientType) {
        return Clients.builder(scheme, endpointGroup).build(clientType);
    }

    public static <T> T newClient(String scheme, EndpointGroup endpointGroup, String path, Class<T> clientType) {
        return Clients.builder(scheme, endpointGroup, path).build(clientType);
    }

    public static <T> T newClient(Scheme scheme, EndpointGroup endpointGroup, Class<T> clientType) {
        return Clients.builder(scheme, endpointGroup).build(clientType);
    }

    public static <T> T newClient(Scheme scheme, EndpointGroup endpointGroup, String path, Class<T> clientType) {
        return Clients.builder(scheme, endpointGroup, path).build(clientType);
    }

    public static <T> T newClient(SessionProtocol protocol, EndpointGroup endpointGroup, Class<T> clientType) {
        return Clients.builder(protocol, endpointGroup).build(clientType);
    }

    public static <T> T newClient(SessionProtocol protocol, EndpointGroup endpointGroup, String path, Class<T> clientType) {
        return Clients.builder(protocol, endpointGroup, path).build(clientType);
    }

    public static ClientBuilder builder(String uri) {
        return Clients.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static ClientBuilder builder(URI uri) {
        return new ClientBuilder(Objects.requireNonNull(uri, "uri"));
    }

    public static ClientBuilder builder(String scheme, EndpointGroup endpointGroup) {
        return Clients.builder(Scheme.parse(Objects.requireNonNull(scheme, "scheme")), endpointGroup);
    }

    public static ClientBuilder builder(String scheme, EndpointGroup endpointGroup, String path) {
        return Clients.builder(Scheme.parse(Objects.requireNonNull(scheme, "scheme")), endpointGroup, path);
    }

    public static ClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return Clients.builder(Scheme.of(SerializationFormat.NONE, Objects.requireNonNull(protocol, "protocol")), endpointGroup);
    }

    public static ClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        return Clients.builder(Scheme.of(SerializationFormat.NONE, Objects.requireNonNull(protocol, "protocol")), endpointGroup, path);
    }

    public static ClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new ClientBuilder(scheme, endpointGroup, null);
    }

    public static ClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(path, "path");
        return new ClientBuilder(scheme, endpointGroup, path);
    }

    public static <T> T newDerivedClient(T client, ClientOptionValue<?> ... additionalOptions) {
        Objects.requireNonNull(additionalOptions, "additionalOptions");
        return Clients.newDerivedClient(client, ImmutableList.copyOf(additionalOptions));
    }

    public static <T> T newDerivedClient(T client, Iterable<ClientOptionValue<?>> additionalOptions) {
        ClientBuilderParams params = Clients.builderParams(client);
        ClientBuilder builder = Clients.newDerivedBuilder(params, true);
        builder.options((Iterable)additionalOptions);
        return Clients.newDerivedClient(builder, params.clientType());
    }

    public static <T> T newDerivedClient(T client, Function<? super ClientOptions, ClientOptions> configurator) {
        ClientBuilderParams params = Clients.builderParams(client);
        ClientBuilder builder = Clients.newDerivedBuilder(params, false);
        builder.options(configurator.apply(params.options()));
        return Clients.newDerivedClient(builder, params.clientType());
    }

    private static <T> T newDerivedClient(ClientBuilder builder, Class<?> clientType) {
        return (T)builder.build(clientType);
    }

    private static ClientBuilder newDerivedBuilder(ClientBuilderParams params, boolean setOptions) {
        ClientBuilder builder = Clients.builder(params.scheme(), params.endpointGroup(), params.absolutePathRef());
        if (setOptions) {
            builder.options(params.options());
        }
        return builder;
    }

    private static ClientBuilderParams builderParams(Object client) {
        Objects.requireNonNull(client, "client");
        ClientBuilderParams params = ClientFactory.ofDefault().clientBuilderParams(client);
        if (params == null) {
            throw new IllegalArgumentException("derivation not supported by: " + client.getClass().getName());
        }
        return params;
    }

    @Nullable
    public static <T> T unwrap(Object client, Class<T> type) {
        ClientBuilderParams params = ClientFactory.ofDefault().clientBuilderParams(client);
        if (params == null) {
            return null;
        }
        return params.options().factory().unwrap(client, type);
    }

    @MustBeClosed
    public static SafeCloseable withHeader(CharSequence name, String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        return Clients.withHeaders(headersBuilder -> headersBuilder.set(name, value));
    }

    @MustBeClosed
    public static SafeCloseable withHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        return Clients.withHeaders(headersBuilder -> headersBuilder.setObject(name, value));
    }

    @MustBeClosed
    public static SafeCloseable withHeaders(Consumer<HttpHeadersBuilder> headerMutator) {
        Objects.requireNonNull(headerMutator, "headerMutator");
        return Clients.withContextCustomizer(ctx -> ctx.mutateAdditionalRequestHeaders(headerMutator));
    }

    @MustBeClosed
    public static SafeCloseable withContextCustomizer(final Consumer<? super ClientRequestContext> contextCustomizer) {
        Objects.requireNonNull(contextCustomizer, "contextCustomizer");
        final ClientThreadLocalState customizers = ClientThreadLocalState.maybeCreate();
        customizers.add(contextCustomizer);
        return new SafeCloseable(){
            boolean closed;

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                customizers.remove(contextCustomizer);
            }
        };
    }

    public static ClientRequestContextCaptor newContextCaptor() {
        return ClientThreadLocalState.maybeCreate().newContextCaptor();
    }

    public static boolean isUndefinedUri(URI uri) {
        return uri == ClientUtil.UNDEFINED_URI;
    }

    private Clients() {
    }
}

