/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ConnectionPoolListenerAdapter;
import io.opentelemetry.testing.internal.armeria.client.ConnectionPoolLoggingListener;
import io.opentelemetry.testing.internal.armeria.client.MetricCollectingConnectionPoolListener;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.util.Ticker;
import io.opentelemetry.testing.internal.armeria.common.util.Unwrappable;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.util.AttributeMap;
import java.net.InetSocketAddress;

public interface ConnectionPoolListener
extends Unwrappable {
    public static ConnectionPoolListener noop() {
        return ConnectionPoolListenerAdapter.NOOP;
    }

    public static ConnectionPoolListener logging() {
        return new ConnectionPoolLoggingListener();
    }

    public static ConnectionPoolListener logging(Ticker ticker) {
        return new ConnectionPoolLoggingListener(ticker);
    }

    @UnstableApi
    public static ConnectionPoolListener metricCollecting(MeterRegistry registry) {
        return ConnectionPoolListener.metricCollecting(registry, new MeterIdPrefix("armeria.client"));
    }

    @UnstableApi
    public static ConnectionPoolListener metricCollecting(MeterRegistry registry, MeterIdPrefix meterIdPrefix) {
        return new MetricCollectingConnectionPoolListener(registry, meterIdPrefix);
    }

    public void connectionOpen(SessionProtocol var1, InetSocketAddress var2, InetSocketAddress var3, AttributeMap var4) throws Exception;

    public void connectionClosed(SessionProtocol var1, InetSocketAddress var2, InetSocketAddress var3, AttributeMap var4) throws Exception;

    @Override
    default public ConnectionPoolListener unwrap() {
        return this;
    }
}

