/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.HttpChannelPool;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.HttpClientFactory;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EmptyEndpointGroupException;
import io.opentelemetry.testing.internal.armeria.client.proxy.HAProxyConfig;
import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyConfig;
import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyType;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.ClientConnectionTimings;
import io.opentelemetry.testing.internal.armeria.common.logging.ClientConnectionTimingsBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogBuilder;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientPendingThrowableUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.client.HttpSession;
import io.opentelemetry.testing.internal.armeria.internal.client.PooledChannel;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.server.ProxiedAddresses;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.resolver.AddressResolverGroup;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;

final class HttpClientDelegate
implements HttpClient {
    private final HttpClientFactory factory;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;

    HttpClientDelegate(HttpClientFactory factory, AddressResolverGroup<InetSocketAddress> addressResolverGroup) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.addressResolverGroup = Objects.requireNonNull(addressResolverGroup, "addressResolverGroup");
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        ProxyConfig proxyConfig;
        Throwable throwable = ClientPendingThrowableUtil.pendingThrowable(ctx);
        if (throwable != null) {
            return HttpClientDelegate.earlyFailedResponse(throwable, ctx, req);
        }
        if (req != ctx.request()) {
            return HttpClientDelegate.earlyFailedResponse(new IllegalStateException("ctx.request() does not match the actual request; did you forget to call ctx.updateRequest() in your decorator?"), ctx, req);
        }
        Endpoint endpoint = ctx.endpoint();
        if (endpoint == null) {
            return HttpClientDelegate.earlyFailedResponse(EmptyEndpointGroupException.get(ctx.endpointGroup()), ctx, req);
        }
        SessionProtocol protocol = ctx.sessionProtocol();
        try {
            proxyConfig = this.getProxyConfig(protocol, endpoint);
        }
        catch (Throwable t) {
            return HttpClientDelegate.earlyFailedResponse(t, ctx, req);
        }
        Endpoint endpointWithPort = endpoint.withDefaultPort(ctx.sessionProtocol());
        EventLoop eventLoop = ctx.eventLoop().withoutContext();
        DecodedHttpResponse res = new DecodedHttpResponse(eventLoop);
        ClientConnectionTimingsBuilder timingsBuilder = ClientConnectionTimings.builder();
        if (endpointWithPort.hasIpAddr() || proxyConfig.proxyType().isForwardProxy()) {
            this.acquireConnectionAndExecute(ctx, endpointWithPort, req, res, timingsBuilder, proxyConfig);
        } else {
            this.resolveAddress(endpointWithPort, ctx, (resolved, cause) -> {
                timingsBuilder.dnsResolutionEnd();
                if (cause == null) {
                    assert (resolved != null);
                    this.acquireConnectionAndExecute(ctx, (Endpoint)resolved, req, res, timingsBuilder, proxyConfig);
                } else {
                    ctx.logBuilder().session(null, ctx.sessionProtocol(), timingsBuilder.build());
                    HttpClientDelegate.earlyFailedResponse(cause, ctx, req, res);
                }
            });
        }
        return res;
    }

    private void resolveAddress(Endpoint endpoint, ClientRequestContext ctx, BiConsumer<@Nullable Endpoint, @Nullable Throwable> onComplete) {
        assert (!endpoint.hasIpAddr() && endpoint.hasPort());
        Future<InetSocketAddress> resolveFuture = this.addressResolverGroup.getResolver(ctx.eventLoop().withoutContext()).resolve(endpoint.toSocketAddress(-1));
        if (resolveFuture.isSuccess()) {
            InetAddress address = resolveFuture.getNow().getAddress();
            onComplete.accept(endpoint.withInetAddress(address), null);
        } else {
            resolveFuture.addListener(future -> {
                if (future.isSuccess()) {
                    InetAddress address = ((InetSocketAddress)resolveFuture.getNow()).getAddress();
                    onComplete.accept(endpoint.withInetAddress(address), null);
                } else {
                    onComplete.accept(null, resolveFuture.cause());
                }
            });
        }
    }

    private void acquireConnectionAndExecute(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        if (ctx.eventLoop().inEventLoop()) {
            this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig);
        } else {
            ctx.eventLoop().execute(() -> this.acquireConnectionAndExecute0(ctx, endpoint, req, res, timingsBuilder, proxyConfig));
        }
    }

    private void acquireConnectionAndExecute0(ClientRequestContext ctx, Endpoint endpoint, HttpRequest req, DecodedHttpResponse res, ClientConnectionTimingsBuilder timingsBuilder, ProxyConfig proxyConfig) {
        HttpChannelPool pool;
        HttpChannelPool.PoolKey key = new HttpChannelPool.PoolKey(endpoint, proxyConfig);
        try {
            pool = this.factory.pool(ctx.eventLoop().withoutContext());
        }
        catch (Throwable t) {
            HttpClientDelegate.earlyFailedResponse(t, ctx, req, res);
            return;
        }
        SessionProtocol protocol = ctx.sessionProtocol();
        SerializationFormat serializationFormat = ctx.log().partial().serializationFormat();
        PooledChannel pooledChannel = pool.acquireNow(protocol, serializationFormat, key);
        if (pooledChannel != null) {
            HttpClientDelegate.logSession(ctx, pooledChannel, null);
            HttpClientDelegate.doExecute(pooledChannel, ctx, req, res);
        } else {
            pool.acquireLater(protocol, serializationFormat, key, timingsBuilder).handle((newPooledChannel, cause) -> {
                HttpClientDelegate.logSession(ctx, newPooledChannel, timingsBuilder.build());
                if (cause == null) {
                    HttpClientDelegate.doExecute(newPooledChannel, ctx, req, res);
                } else {
                    HttpClientDelegate.earlyFailedResponse(cause, ctx, req, res);
                }
                return null;
            });
        }
    }

    private ProxyConfig getProxyConfig(SessionProtocol protocol, Endpoint endpoint) {
        ProxyConfig proxyConfig = this.factory.proxyConfigSelector().select(protocol, endpoint);
        Objects.requireNonNull(proxyConfig, "proxyConfig");
        if (proxyConfig.proxyType() == ProxyType.HAPROXY && ((HAProxyConfig)proxyConfig).sourceAddress() == null) {
            InetSocketAddress proxyAddress = proxyConfig.proxyAddress();
            assert (proxyAddress != null);
            ServiceRequestContext serviceCtx = ServiceRequestContext.currentOrNull();
            if (serviceCtx != null) {
                ProxiedAddresses proxiedAddresses = serviceCtx.proxiedAddresses();
                return ProxyConfig.haproxy(proxyAddress, proxiedAddresses.sourceAddress());
            }
        }
        return proxyConfig;
    }

    private static void logSession(ClientRequestContext ctx, @Nullable PooledChannel pooledChannel, @Nullable ClientConnectionTimings connectionTimings) {
        if (pooledChannel != null) {
            Channel channel = pooledChannel.get();
            SessionProtocol actualProtocol = pooledChannel.protocol();
            ctx.logBuilder().session(channel, actualProtocol, connectionTimings);
        } else {
            ctx.logBuilder().session(null, ctx.sessionProtocol(), connectionTimings);
        }
    }

    private static HttpResponse earlyFailedResponse(Throwable t, ClientRequestContext ctx, HttpRequest req) {
        UnprocessedRequestException cause = UnprocessedRequestException.of(t);
        HttpClientDelegate.handleEarlyRequestException(ctx, req, cause);
        return HttpResponse.ofFailure(cause);
    }

    private static void earlyFailedResponse(Throwable t, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        UnprocessedRequestException cause = UnprocessedRequestException.of(t);
        HttpClientDelegate.handleEarlyRequestException(ctx, req, cause);
        res.close(cause);
    }

    private static void handleEarlyRequestException(ClientRequestContext ctx, HttpRequest req, Throwable cause) {
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            req.abort(cause);
            RequestLogBuilder logBuilder = ctx.logBuilder();
            logBuilder.endRequest(cause);
            logBuilder.endResponse(cause);
        }
    }

    private static void doExecute(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        Channel channel = pooledChannel.get();
        HttpSession session = HttpSession.get(channel);
        res.init(session.inboundTrafficController());
        session.invoke(pooledChannel, ctx, req, res);
    }
}

