/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.RequestTarget;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.util.AbstractUnwrappable;
import io.opentelemetry.testing.internal.armeria.common.util.SystemInfo;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.DefaultClientRequestContext;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserClient<I extends Request, O extends Response>
extends AbstractUnwrappable<Client<I, O>>
implements ClientBuilderParams {
    private static final Logger logger = LoggerFactory.getLogger(UserClient.class);
    private static boolean warnedNullRequestId;
    private final ClientBuilderParams params;
    private final MeterRegistry meterRegistry;
    private final Function<CompletableFuture<O>, O> futureConverter;
    private final BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory;

    protected UserClient(ClientBuilderParams params, Client<I, O> delegate, MeterRegistry meterRegistry, Function<CompletableFuture<O>, O> futureConverter, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory) {
        super(delegate);
        this.params = params;
        this.meterRegistry = meterRegistry;
        this.futureConverter = futureConverter;
        this.errorResponseFactory = errorResponseFactory;
    }

    @Override
    public final Scheme scheme() {
        return this.params.scheme();
    }

    @Override
    public final EndpointGroup endpointGroup() {
        return this.params.endpointGroup();
    }

    @Override
    public final String absolutePathRef() {
        return this.params.absolutePathRef();
    }

    @Override
    public final URI uri() {
        return this.params.uri();
    }

    @Override
    public final Class<?> clientType() {
        return this.params.clientType();
    }

    @Override
    public final ClientOptions options() {
        return this.params.options();
    }

    protected final O execute(SessionProtocol protocol, HttpMethod method, RequestTarget reqTarget, I req) {
        return this.execute(protocol, method, reqTarget, req, RequestOptions.of());
    }

    protected final O execute(SessionProtocol protocol, HttpMethod method, RequestTarget reqTarget, I req, RequestOptions requestOptions) {
        return this.execute(protocol, this.endpointGroup(), method, reqTarget, req, requestOptions);
    }

    protected final O execute(SessionProtocol protocol, EndpointGroup endpointGroup, HttpMethod method, RequestTarget reqTarget, I req) {
        return this.execute(protocol, endpointGroup, method, reqTarget, req, RequestOptions.of());
    }

    protected final O execute(SessionProtocol protocol, EndpointGroup endpointGroup, HttpMethod method, RequestTarget reqTarget, I req, RequestOptions requestOptions) {
        RpcRequest rpcReq;
        HttpRequest httpReq;
        RequestId id = this.nextRequestId();
        if (req instanceof HttpRequest) {
            httpReq = (HttpRequest)req;
            rpcReq = null;
        } else {
            httpReq = null;
            rpcReq = (RpcRequest)req;
        }
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(this.meterRegistry, protocol, id, method, reqTarget, this.options(), httpReq, rpcReq, requestOptions, System.nanoTime(), SystemInfo.currentTimeMicros());
        return ClientUtil.initContextAndExecuteWithFallback((Client)this.unwrap(), ctx, endpointGroup, this.futureConverter, this.errorResponseFactory);
    }

    private RequestId nextRequestId() {
        RequestId id = this.options().requestIdGenerator().get();
        if (id == null) {
            if (!warnedNullRequestId) {
                warnedNullRequestId = true;
                logger.warn("requestIdGenerator.get() returned null; using RequestId.random()");
            }
            return RequestId.random();
        }
        return id;
    }
}

