/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import com.google.errorprone.annotations.CheckReturnValue;
import io.opentelemetry.testing.internal.armeria.client.BlockingWebClient;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.DefaultWebClient;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.client.RestClient;
import io.opentelemetry.testing.internal.armeria.client.WebClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.WebClientRequestPreparation;
import io.opentelemetry.testing.internal.armeria.client.WebClientUtil;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.Unwrappable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;

public interface WebClient
extends ClientBuilderParams,
Unwrappable {
    public static WebClient of() {
        return DefaultWebClient.DEFAULT;
    }

    public static WebClient of(String uri) {
        return WebClient.builder(uri).build();
    }

    public static WebClient of(URI uri) {
        return WebClient.builder(uri).build();
    }

    public static WebClient of(String protocol, EndpointGroup endpointGroup) {
        return WebClient.builder(protocol, endpointGroup).build();
    }

    public static WebClient of(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return WebClient.builder(protocol, endpointGroup).build();
    }

    public static WebClient of(String protocol, EndpointGroup endpointGroup, String path) {
        return WebClient.builder(protocol, endpointGroup, path).build();
    }

    public static WebClient of(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        return WebClient.builder(protocol, endpointGroup, path).build();
    }

    public static WebClientBuilder builder() {
        return new WebClientBuilder();
    }

    public static WebClientBuilder builder(String uri) {
        return WebClient.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static WebClientBuilder builder(URI uri) {
        return new WebClientBuilder(uri);
    }

    public static WebClientBuilder builder(String protocol, EndpointGroup endpointGroup) {
        return WebClient.builder(SessionProtocol.of(Objects.requireNonNull(protocol, "protocol")), endpointGroup);
    }

    public static WebClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new WebClientBuilder(protocol, endpointGroup, null);
    }

    public static WebClientBuilder builder(String protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(path, "path");
        return WebClient.builder(SessionProtocol.of(protocol), endpointGroup, path);
    }

    public static WebClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(path, "path");
        return new WebClientBuilder(protocol, endpointGroup, path);
    }

    @CheckReturnValue
    default public HttpResponse execute(HttpRequest req) {
        return this.execute(req, RequestOptions.of());
    }

    @CheckReturnValue
    public HttpResponse execute(HttpRequest var1, RequestOptions var2);

    @CheckReturnValue
    default public HttpResponse execute(AggregatedHttpRequest aggregatedReq) {
        Objects.requireNonNull(aggregatedReq, "aggregatedReq");
        return this.execute(aggregatedReq.toHttpRequest(), DefaultWebClient.RESPONSE_STREAMING_REQUEST_OPTIONS);
    }

    @CheckReturnValue
    default public HttpResponse execute(RequestHeaders headers) {
        return this.execute(HttpRequest.of(headers), DefaultWebClient.RESPONSE_STREAMING_REQUEST_OPTIONS);
    }

    @CheckReturnValue
    default public HttpResponse execute(RequestHeaders headers, HttpData content) {
        return this.execute(HttpRequest.of(headers, content), DefaultWebClient.RESPONSE_STREAMING_REQUEST_OPTIONS);
    }

    @CheckReturnValue
    default public HttpResponse execute(RequestHeaders headers, byte[] content) {
        return this.execute(HttpRequest.of(headers, HttpData.wrap(content)), DefaultWebClient.RESPONSE_STREAMING_REQUEST_OPTIONS);
    }

    @CheckReturnValue
    default public HttpResponse execute(RequestHeaders headers, String content) {
        return this.execute(HttpRequest.of(headers, HttpData.ofUtf8(content)), DefaultWebClient.RESPONSE_STREAMING_REQUEST_OPTIONS);
    }

    @CheckReturnValue
    default public HttpResponse execute(RequestHeaders headers, String content, Charset charset) {
        return this.execute(HttpRequest.of(headers, HttpData.of(charset, content)), DefaultWebClient.RESPONSE_STREAMING_REQUEST_OPTIONS);
    }

    default public WebClientRequestPreparation prepare() {
        return new WebClientRequestPreparation(this);
    }

    @CheckReturnValue
    default public HttpResponse options(String path) {
        return this.options(path, null);
    }

    @CheckReturnValue
    default public HttpResponse options(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.OPTIONS, WebClientUtil.addQueryParams(path, params)));
    }

    @CheckReturnValue
    default public HttpResponse get(String path) {
        return this.get(path, null);
    }

    @CheckReturnValue
    default public HttpResponse get(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.GET, WebClientUtil.addQueryParams(path, params)));
    }

    @CheckReturnValue
    default public HttpResponse head(String path) {
        return this.head(path, null);
    }

    @CheckReturnValue
    default public HttpResponse head(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.HEAD, WebClientUtil.addQueryParams(path, params)));
    }

    @CheckReturnValue
    default public HttpResponse post(String path, HttpData content) {
        return this.post(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse post(String path, @Nullable QueryParams params, HttpData content) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse post(String path, byte[] content) {
        return this.post(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse post(String path, @Nullable QueryParams params, byte[] content) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse post(String path, String content) {
        return this.post(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse post(String path, @Nullable QueryParams params, String content) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse post(String path, String content, Charset charset) {
        return this.post(path, null, content, charset);
    }

    @CheckReturnValue
    default public HttpResponse post(String path, @Nullable QueryParams params, String content, Charset charset) {
        return this.execute(RequestHeaders.of(HttpMethod.POST, WebClientUtil.addQueryParams(path, params)), content, charset);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, HttpData content) {
        return this.put(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, @Nullable QueryParams params, HttpData content) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, byte[] content) {
        return this.put(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, @Nullable QueryParams params, byte[] content) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, String content) {
        return this.put(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, @Nullable QueryParams params, String content) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, String content, Charset charset) {
        return this.put(path, null, content, charset);
    }

    @CheckReturnValue
    default public HttpResponse put(String path, @Nullable QueryParams params, String content, Charset charset) {
        return this.execute(RequestHeaders.of(HttpMethod.PUT, WebClientUtil.addQueryParams(path, params)), content, charset);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, HttpData content) {
        return this.patch(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, @Nullable QueryParams params, HttpData content) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, byte[] content) {
        return this.patch(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, @Nullable QueryParams params, byte[] content) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, String content) {
        return this.patch(path, null, content);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, @Nullable QueryParams params, String content) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, String content, Charset charset) {
        return this.patch(path, null, content, charset);
    }

    @CheckReturnValue
    default public HttpResponse patch(String path, @Nullable QueryParams params, String content, Charset charset) {
        return this.execute(RequestHeaders.of(HttpMethod.PATCH, WebClientUtil.addQueryParams(path, params)), content, charset);
    }

    @CheckReturnValue
    default public HttpResponse delete(String path) {
        return this.delete(path, null);
    }

    @CheckReturnValue
    default public HttpResponse delete(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.DELETE, WebClientUtil.addQueryParams(path, params)));
    }

    @CheckReturnValue
    default public HttpResponse trace(String path) {
        return this.trace(path, null);
    }

    @CheckReturnValue
    default public HttpResponse trace(String path, @Nullable QueryParams params) {
        return this.execute(RequestHeaders.of(HttpMethod.TRACE, WebClientUtil.addQueryParams(path, params)));
    }

    @UnstableApi
    public BlockingWebClient blocking();

    @UnstableApi
    public RestClient asRestClient();

    @Override
    public HttpClient unwrap();
}

