/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.AbstractHttpResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseWrapper;
import io.opentelemetry.testing.internal.armeria.client.WebSocketHttp1ResponseWrapper;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ProtocolViolationException;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClosedStreamExceptionUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.client.HttpSession;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.InboundTrafficController;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.internal.common.NoopKeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.math.LongMath;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelDuplexHandler;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPipeline;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DecoderResult;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpClientCodec;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpContent;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpObject;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpUtil;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.LastHttpContent;
import io.opentelemetry.testing.internal.io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebSocketHttp1ClientChannelHandler
extends ChannelDuplexHandler
implements HttpResponseDecoder {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHttp1ClientChannelHandler.class);
    private final Channel channel;
    private final InboundTrafficController inboundTrafficController;
    @Nullable
    private HttpResponseWrapper res;
    private final KeepAliveHandler keepAliveHandler;
    private State state = State.NEEDS_HANDSHAKE_RESPONSE;
    @Nullable
    private HttpSession httpSession;

    WebSocketHttp1ClientChannelHandler(Channel channel) {
        this.channel = channel;
        this.inboundTrafficController = InboundTrafficController.ofHttp1(channel);
        this.keepAliveHandler = new NoopKeepAliveHandler();
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public InboundTrafficController inboundTrafficController() {
        return this.inboundTrafficController;
    }

    @Override
    public HttpResponseWrapper addResponse(int id, DecodedHttpResponse decodedHttpResponse, ClientRequestContext ctx, EventLoop eventLoop) {
        assert (this.res == null);
        this.res = new WebSocketHttp1ResponseWrapper(decodedHttpResponse, eventLoop, ctx, ctx.responseTimeoutMillis(), ctx.maxResponseLength());
        return this.res;
    }

    @Override
    @Nullable
    public HttpResponseWrapper getResponse(int unused) {
        return this.res;
    }

    @Override
    @Nullable
    public HttpResponseWrapper removeResponse(int unused) {
        return this.res;
    }

    @Override
    public boolean hasUnfinishedResponses() {
        return this.res != null;
    }

    @Override
    public boolean reserveUnfinishedResponse(int unused) {
        return true;
    }

    @Override
    public void decrementUnfinishedResponses() {
    }

    @Override
    public void failUnfinishedResponses(Throwable cause) {
        if (this.res != null) {
            this.res.close(cause);
        }
    }

    @Override
    public HttpSession session() {
        if (this.httpSession != null) {
            return this.httpSession;
        }
        this.httpSession = HttpSession.get(this.channel);
        return this.httpSession;
    }

    @Override
    public KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.keepAliveHandler.destroy();
        if (this.res != null) {
            this.res.close(ClosedStreamExceptionUtil.newClosedSessionException(ctx));
        }
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            switch (this.state.ordinal()) {
                case 0: {
                    if (!(msg instanceof HttpObject)) {
                        ctx.fireChannelRead(ReferenceCountUtil.retain(msg));
                        return;
                    }
                    if (!(msg instanceof HttpResponse)) {
                        this.failWithUnexpectedMessageType(ctx, msg, HttpResponse.class);
                        return;
                    }
                    HttpResponse nettyRes = (HttpResponse)msg;
                    DecoderResult decoderResult = nettyRes.decoderResult();
                    if (!decoderResult.isSuccess()) {
                        this.fail(ctx, new ProtocolViolationException(decoderResult.cause()));
                        return;
                    }
                    if (!HttpUtil.isKeepAlive(nettyRes)) {
                        this.session().markUnacquirable();
                    }
                    if (this.res == null && ArmeriaHttpUtil.isRequestTimeoutResponse(nettyRes)) {
                        ctx.close();
                        return;
                    }
                    this.res.startResponse();
                    ResponseHeaders responseHeaders = ArmeriaHttpUtil.toArmeria(nettyRes);
                    if (responseHeaders.status() == HttpStatus.SWITCHING_PROTOCOLS) {
                        this.state = State.NEEDS_HANDSHAKE_RESPONSE_END;
                    }
                    if (this.res.tryWriteResponseHeaders(responseHeaders)) return;
                    this.fail(ctx, ClosedStreamExceptionUtil.newClosedSessionException(ctx));
                    return;
                }
                case 1: {
                    if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                        this.failWithUnexpectedMessageType(ctx, msg, LastHttpContent.EMPTY_LAST_CONTENT.getClass());
                        return;
                    }
                    this.state = State.UPGRADE_COMPLETE;
                    ChannelPipeline pipeline = ctx.pipeline();
                    pipeline.remove(HttpClientCodec.class);
                    return;
                }
                case 2: {
                    assert (msg instanceof ByteBuf);
                    ByteBuf data = (ByteBuf)msg;
                    int dataLength = data.readableBytes();
                    if (dataLength <= 0) return;
                    long maxContentLength = this.res.maxContentLength();
                    long writtenBytes = this.res.writtenBytes();
                    if (maxContentLength > 0L && writtenBytes > maxContentLength - (long)dataLength) {
                        long transferred = LongMath.saturatedAdd(writtenBytes, dataLength);
                        this.res.close(AbstractHttpResponseDecoder.contentTooLargeException(this.res, transferred));
                        ctx.close();
                        return;
                    }
                    if (this.res.tryWriteData(HttpData.wrap(data.retain()))) return;
                    ctx.close();
                    return;
                }
            }
            return;
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    private void failWithUnexpectedMessageType(ChannelHandlerContext ctx, Object msg, Class<?> expected) {
        String message;
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append("unexpected message type: " + msg.getClass().getName() + " (expected: " + expected.getName() + ", channel: " + ctx.channel() + ')');
            message = buf.toString();
        }
        this.fail(ctx, new ProtocolViolationException(message));
    }

    private void fail(ChannelHandlerContext ctx, Throwable cause) {
        if (this.res != null) {
            this.res.close(cause);
        } else {
            logger.warn("Unexpected exception:", cause);
        }
        ctx.close();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpContent) {
            ctx.write(((HttpContent)msg).content(), promise);
            return;
        }
        ctx.write(msg, promise);
    }

    private static enum State {
        NEEDS_HANDSHAKE_RESPONSE,
        NEEDS_HANDSHAKE_RESPONSE_END,
        UPGRADE_COMPLETE;

    }
}

