/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.AbstractCircuitBreakerClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerClient;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerMapping;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRule;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class CircuitBreakerClientBuilder
extends AbstractCircuitBreakerClientBuilder<HttpRequest, HttpResponse> {
    static final int DEFAULT_MAX_CONTENT_LENGTH = Integer.MAX_VALUE;
    private final boolean needsContentInRule;
    private final int maxContentLength;

    CircuitBreakerClientBuilder(CircuitBreakerRule rule) {
        super(rule);
        this.needsContentInRule = false;
        this.maxContentLength = 0;
    }

    CircuitBreakerClientBuilder(CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent, int maxContentLength) {
        super(ruleWithContent);
        this.needsContentInRule = true;
        this.maxContentLength = maxContentLength;
    }

    public CircuitBreakerClient build(HttpClient delegate) {
        if (this.needsContentInRule) {
            return new CircuitBreakerClient(delegate, this.handler(), this.ruleWithContent(), this.maxContentLength, this.fallback());
        }
        return new CircuitBreakerClient(delegate, this.handler(), this.rule(), this.fallback());
    }

    public Function<? super HttpClient, CircuitBreakerClient> newDecorator() {
        return this::build;
    }

    public CircuitBreakerClientBuilder mapping(CircuitBreakerMapping mapping) {
        return (CircuitBreakerClientBuilder)super.mapping(mapping);
    }

    @UnstableApi
    public CircuitBreakerClientBuilder handler(CircuitBreakerClientHandler handler) {
        return (CircuitBreakerClientBuilder)super.handler(handler);
    }

    public CircuitBreakerClientBuilder recover(BiFunction<? super ClientRequestContext, ? super HttpRequest, ? extends HttpResponse> fallback) {
        return (CircuitBreakerClientBuilder)super.recover(fallback);
    }
}

