/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.AbstractRuleBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerDecision;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRule;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleUtil;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.AbstractRuleBuilderUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class CircuitBreakerRuleBuilder
extends AbstractRuleBuilder<CircuitBreakerRuleBuilder> {
    CircuitBreakerRuleBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public CircuitBreakerRule thenSuccess() {
        return this.build(CircuitBreakerDecision.success());
    }

    public CircuitBreakerRule thenFailure() {
        return this.build(CircuitBreakerDecision.failure());
    }

    public CircuitBreakerRule thenIgnore() {
        return this.build(CircuitBreakerDecision.ignore());
    }

    private CircuitBreakerRule build(CircuitBreakerDecision decision) {
        BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter = AbstractRuleBuilderUtil.buildFilter(this.requestHeadersFilter(), this.responseHeadersFilter(), this.responseTrailersFilter(), this.grpcTrailersFilter(), this.exceptionFilter(), this.totalDurationFilter(), false);
        return CircuitBreakerRuleBuilder.build(ruleFilter, decision, this.requiresResponseTrailers());
    }

    static CircuitBreakerRule build(final BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter, CircuitBreakerDecision decision, final boolean requiresResponseTrailers) {
        final CompletableFuture<CircuitBreakerDecision> decisionFuture = decision == CircuitBreakerDecision.success() ? CircuitBreakerRuleUtil.SUCCESS_DECISION : (decision == CircuitBreakerDecision.failure() ? CircuitBreakerRuleUtil.FAILURE_DECISION : (decision == CircuitBreakerDecision.ignore() ? CircuitBreakerRuleUtil.IGNORE_DECISION : CircuitBreakerRuleUtil.NEXT_DECISION));
        return new CircuitBreakerRule(){

            @Override
            public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext ctx, @Nullable Throwable cause) {
                return (Boolean)ruleFilter.apply(ctx, cause) != false ? decisionFuture : CircuitBreakerRuleUtil.NEXT_DECISION;
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }
}

