/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreaker;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.ClientCircuitBreakerGenerator;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.DefaultCircuitBreakerCallback;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.FailFastException;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.circuitbreaker.CircuitBreakerCallback;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultCircuitBreakerClientHandler
implements CircuitBreakerClientHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCircuitBreakerClientHandler.class);
    private final ClientCircuitBreakerGenerator<CircuitBreaker> mapping;

    DefaultCircuitBreakerClientHandler(ClientCircuitBreakerGenerator<CircuitBreaker> mapping) {
        this.mapping = mapping;
    }

    @Override
    public CircuitBreakerCallback tryRequest(ClientRequestContext ctx, Request req) {
        CircuitBreaker circuitBreaker;
        try {
            circuitBreaker = Objects.requireNonNull(this.mapping.get(ctx, req), "circuitBreaker");
        }
        catch (Throwable t) {
            logger.warn("Failed to get a circuit breaker from mapping ({}) for context ({})", new Object[]{this.mapping, ctx, t});
            return null;
        }
        if (!circuitBreaker.tryRequest()) {
            throw new FailFastException(circuitBreaker);
        }
        if (circuitBreaker instanceof CircuitBreakerCallback) {
            return (CircuitBreakerCallback)((Object)circuitBreaker);
        }
        return new DefaultCircuitBreakerCallback(circuitBreaker);
    }
}

