/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.RoundRobinStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.StickyEndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.WeightRampingUpStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.WeightRampingUpStrategyBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.WeightedRoundRobinStrategy;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface EndpointSelectionStrategy {
    public static EndpointSelectionStrategy weightedRoundRobin() {
        return WeightedRoundRobinStrategy.INSTANCE;
    }

    public static EndpointSelectionStrategy roundRobin() {
        return RoundRobinStrategy.INSTANCE;
    }

    @UnstableApi
    public static EndpointSelectionStrategy rampingUp() {
        return WeightRampingUpStrategy.INSTANCE;
    }

    @UnstableApi
    public static WeightRampingUpStrategyBuilder builderForRampingUp() {
        return new WeightRampingUpStrategyBuilder();
    }

    public static EndpointSelectionStrategy sticky(ToLongFunction<? super ClientRequestContext> requestContextHasher) {
        return new StickyEndpointSelectionStrategy(requestContextHasher);
    }

    public EndpointSelector newSelector(EndpointGroup var1);
}

