/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroupException;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

@UnstableApi
public final class EndpointSelectionTimeoutException
extends EndpointGroupException {
    private static final long serialVersionUID = -3079582212067997365L;
    private static final EndpointSelectionTimeoutException INSTANCE = new EndpointSelectionTimeoutException();

    public static EndpointSelectionTimeoutException get(EndpointGroup endpointGroup, long selectionTimeoutMillis) {
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Preconditions.checkArgument(selectionTimeoutMillis >= 0L, "selectionTimeoutMillis: %s (expected: >= 0)", selectionTimeoutMillis);
        return Flags.verboseExceptionSampler().isSampled(EndpointSelectionTimeoutException.class) ? new EndpointSelectionTimeoutException(endpointGroup, selectionTimeoutMillis) : INSTANCE;
    }

    private EndpointSelectionTimeoutException() {
    }

    private EndpointSelectionTimeoutException(EndpointGroup endpointGroup, long selectionTimeoutMillis) {
        super("Failed to select within " + selectionTimeoutMillis + " ms an endpoint from: " + endpointGroup);
    }
}

