/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.endpoint.FileWatcherRegistry;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileWatcherRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FileWatcherRunnable.class);
    private final WatchService watchService;
    private final FileWatcherRegistry.FileSystemWatchContext fileSystemWatchContext;

    FileWatcherRunnable(WatchService watchService, FileWatcherRegistry.FileSystemWatchContext fileSystemWatchContext) {
        this.watchService = watchService;
        this.fileSystemWatchContext = fileSystemWatchContext;
    }

    @Override
    public void run() {
        try {
            WatchKey key;
            while ((key = this.watchService.take()) != null) {
                Path dirPath = (Path)key.watchable();
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (event.kind().type() == Path.class) {
                        Path filePath = dirPath.resolve((Path)event.context());
                        if (event.kind().equals(StandardWatchEventKinds.ENTRY_DELETE)) {
                            logger.warn("Ignoring a deleted file: {}", (Object)filePath);
                            continue;
                        }
                        this.runCallback(filePath);
                        continue;
                    }
                    if (event.kind().equals(StandardWatchEventKinds.OVERFLOW)) {
                        logger.debug("Watch events may have been lost for path: {}", (Object)dirPath);
                        this.runCallback(dirPath);
                        continue;
                    }
                    logger.debug("Ignoring unexpected event type: {}", (Object)event.kind().name());
                }
                boolean reset = key.reset();
                if (reset) continue;
                logger.info("Path will no longer be watched: {}", (Object)dirPath);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.trace("File watching thread interrupted");
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            // empty catch block
        }
    }

    private void runCallback(Path path) {
        this.fileSystemWatchContext.watchEvents().stream().filter(ctx -> path.startsWith(ctx.dirPath())).forEach(ctx -> {
            try {
                ((FileWatchEvent)ctx).runCallback();
            }
            catch (Exception e) {
                logger.warn("Unexpected error from listener: {} ", (Object)path, (Object)e);
            }
        });
    }

    static class FileWatchEvent {
        private final WatchKey watchKey;
        private final Runnable callback;
        private final Path dirPath;

        FileWatchEvent(WatchKey watchKey, Runnable callback, Path dirPath) {
            this.watchKey = watchKey;
            this.callback = callback;
            this.dirPath = dirPath;
        }

        private void runCallback() {
            this.callback.run();
        }

        Path dirPath() {
            return this.dirPath;
        }

        void cancel() {
            this.watchKey.cancel();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("dirPath", this.dirPath).add("watchable", this.watchKey.watchable()).add("isValid", this.watchKey.isValid()).toString();
        }
    }
}

