/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.AbstractEndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.hash.Hashing;
import java.util.List;
import java.util.Objects;
import java.util.function.ToLongFunction;

final class StickyEndpointSelectionStrategy
implements EndpointSelectionStrategy {
    private final ToLongFunction<? super ClientRequestContext> requestContextHasher;

    StickyEndpointSelectionStrategy(ToLongFunction<? super ClientRequestContext> requestContextHasher) {
        this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new StickyEndpointSelector(endpointGroup, this.requestContextHasher);
    }

    private static final class StickyEndpointSelector
    extends AbstractEndpointSelector {
        private final ToLongFunction<? super ClientRequestContext> requestContextHasher;

        StickyEndpointSelector(EndpointGroup endpointGroup, ToLongFunction<? super ClientRequestContext> requestContextHasher) {
            super(endpointGroup);
            this.requestContextHasher = Objects.requireNonNull(requestContextHasher, "requestContextHasher");
            this.initialize();
        }

        @Override
        public Endpoint selectNow(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.group().endpoints();
            if (endpoints.isEmpty()) {
                return null;
            }
            long key = this.requestContextHasher.applyAsLong(ctx);
            int nearest = Hashing.consistentHash(key, endpoints.size());
            return endpoints.get(nearest);
        }
    }
}

