/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.dns;

import io.opentelemetry.testing.internal.armeria.client.AbstractDnsResolverBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.AbstractDynamicEndpointGroupBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.DynamicEndpointGroupSetters;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsQueryListener;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.common.CommonPools;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.TransportType;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DefaultDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsNameResolverBuilder;
import java.net.IDN;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

abstract class DnsEndpointGroupBuilder<SELF extends DnsEndpointGroupBuilder<SELF>>
extends AbstractDnsResolverBuilder<SELF>
implements DynamicEndpointGroupSetters<SELF> {
    private final String hostname;
    @Nullable
    private EventLoop eventLoop;
    private Backoff backoff = Backoff.exponential(1000L, 32000L).withJitter(0.2);
    private EndpointSelectionStrategy selectionStrategy = EndpointSelectionStrategy.weightedRoundRobin();
    private final DnsDynamicEndpointGroupBuilder dnsDynamicEndpointGroupBuilder;
    private final List<DnsQueryListener> dnsQueryListeners = new ArrayList<DnsQueryListener>();

    DnsEndpointGroupBuilder(String hostname) {
        this.hostname = Ascii.toLowerCase(IDN.toASCII(Objects.requireNonNull(hostname, "hostname"), 1));
        this.dnsDynamicEndpointGroupBuilder = new DnsDynamicEndpointGroupBuilder(DnsUtil.defaultDnsQueryTimeoutMillis());
    }

    final String hostname() {
        return this.hostname;
    }

    final EventLoop getOrAcquireEventLoop() {
        if (this.eventLoop != null) {
            return this.eventLoop;
        }
        return CommonPools.workerGroup().next();
    }

    public SELF eventLoop(EventLoop eventLoop) {
        Objects.requireNonNull(eventLoop, "eventLoop");
        Preconditions.checkArgument(TransportType.isSupported(eventLoop), "unsupported event loop type: %s", (Object)eventLoop);
        this.eventLoop = eventLoop;
        return (SELF)((DnsEndpointGroupBuilder)this.self());
    }

    final Backoff backoff() {
        return this.backoff;
    }

    public SELF backoff(Backoff backoff) {
        this.backoff = Objects.requireNonNull(backoff, "backoff");
        return (SELF)((DnsEndpointGroupBuilder)this.self());
    }

    public SELF selectionStrategy(EndpointSelectionStrategy selectionStrategy) {
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        return (SELF)((DnsEndpointGroupBuilder)this.self());
    }

    final EndpointSelectionStrategy selectionStrategy() {
        return this.selectionStrategy;
    }

    final boolean shouldAllowEmptyEndpoints() {
        return this.dnsDynamicEndpointGroupBuilder.shouldAllowEmptyEndpoints();
    }

    @Override
    public SELF allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        this.dnsDynamicEndpointGroupBuilder.allowEmptyEndpoints(allowEmptyEndpoints);
        return (SELF)((DnsEndpointGroupBuilder)this.self());
    }

    @Override
    public SELF selectionTimeout(Duration selectionTimeout) {
        this.dnsDynamicEndpointGroupBuilder.selectionTimeout(selectionTimeout);
        return (SELF)((DnsEndpointGroupBuilder)this.self());
    }

    @Override
    public SELF selectionTimeoutMillis(long selectionTimeoutMillis) {
        this.dnsDynamicEndpointGroupBuilder.selectionTimeoutMillis(selectionTimeoutMillis);
        return (SELF)((DnsEndpointGroupBuilder)this.self());
    }

    final long selectionTimeoutMillis() {
        return this.dnsDynamicEndpointGroupBuilder.selectionTimeoutMillis();
    }

    final DefaultDnsResolver buildResolver(EventLoop eventLoop) {
        return this.buildResolver(unused -> {}, eventLoop);
    }

    final DefaultDnsResolver buildResolver(Consumer<DnsNameResolverBuilder> customizer, EventLoop eventLoop) {
        DnsNameResolverBuilder resolverBuilder = new DnsNameResolverBuilder(eventLoop);
        customizer.accept(resolverBuilder);
        this.buildConfigurator(eventLoop.parent()).accept(resolverBuilder);
        return DefaultDnsResolver.of(resolverBuilder.build(), this.maybeCreateDnsCache(), eventLoop, this.searchDomains(), this.ndots(), this.queryTimeoutMillis(), this.hostsFileEntriesResolver());
    }

    @UnstableApi
    public SELF addDnsQueryListeners(Iterable<? extends DnsQueryListener> dnsQueryListeners) {
        Objects.requireNonNull(dnsQueryListeners, "dnsQueryListeners");
        for (DnsQueryListener dnsQueryListener : dnsQueryListeners) {
            this.dnsQueryListeners.add(dnsQueryListener);
        }
        return (SELF)((DnsEndpointGroupBuilder)this.self());
    }

    @UnstableApi
    public SELF addDnsQueryListeners(DnsQueryListener ... dnsQueryListeners) {
        Objects.requireNonNull(dnsQueryListeners, "dnsQueryListeners");
        return this.addDnsQueryListeners(ImmutableList.copyOf(dnsQueryListeners));
    }

    final List<DnsQueryListener> dnsQueryListeners() {
        return this.dnsQueryListeners;
    }

    private static class DnsDynamicEndpointGroupBuilder
    extends AbstractDynamicEndpointGroupBuilder<DnsDynamicEndpointGroupBuilder> {
        protected DnsDynamicEndpointGroupBuilder(long selectionTimeoutMillis) {
            super(selectionTimeoutMillis);
        }

        @Override
        public boolean shouldAllowEmptyEndpoints() {
            return super.shouldAllowEmptyEndpoints();
        }

        @Override
        public long selectionTimeoutMillis() {
            return super.selectionTimeoutMillis();
        }
    }
}

