/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.dns;

import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsQueryListener;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsTextEndpointGroupBuilder;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.ByteArrayDnsRecord;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DefaultDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecord;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecordType;
import java.util.List;
import java.util.function.Function;

public final class DnsTextEndpointGroup
extends DnsEndpointGroup {
    private final Function<byte[], @Nullable Endpoint> mapping;

    public static DnsTextEndpointGroup of(String hostname, Function<byte[], @Nullable Endpoint> mapping) {
        return DnsTextEndpointGroup.builder(hostname, mapping).build();
    }

    public static DnsTextEndpointGroupBuilder builder(String hostname, Function<byte[], @Nullable Endpoint> mapping) {
        return new DnsTextEndpointGroupBuilder(hostname, mapping);
    }

    DnsTextEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, long selectionTimeoutMillis, DefaultDnsResolver resolver, EventLoop eventLoop, Backoff backoff, int minTtl, int maxTtl, String hostname, Function<byte[], @Nullable Endpoint> mapping, List<DnsQueryListener> dnsQueryListeners) {
        super(selectionStrategy, allowEmptyEndpoints, selectionTimeoutMillis, resolver, eventLoop, ImmutableList.of(DnsQuestionWithoutTrailingDot.of(hostname, DnsRecordType.TXT)), backoff, minTtl, maxTtl, dnsQueryListeners);
        this.mapping = mapping;
        this.start();
    }

    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (DnsRecord r : records) {
            Endpoint endpoint;
            if (!(r instanceof ByteArrayDnsRecord) || r.type() != DnsRecordType.TXT) continue;
            byte[] content = ((ByteArrayDnsRecord)r).content();
            if (content.length == 0) {
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            int txtLen = content[0] & 0xFF;
            if (txtLen == 0) continue;
            if (content.length != txtLen + 1) {
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            byte[] txt = new byte[txtLen];
            System.arraycopy(content, 1, txt, 0, txtLen);
            try {
                endpoint = this.mapping.apply(txt);
            }
            catch (Exception e) {
                this.warnInvalidRecord(DnsRecordType.TXT, content);
                continue;
            }
            if (endpoint == null) continue;
            builder.add(endpoint);
        }
        ImmutableSet endpoints = builder.build();
        this.logDnsResolutionResult(endpoints, ttl);
        return endpoints;
    }
}

