/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContextCaptor;
import io.opentelemetry.testing.internal.armeria.client.Clients;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.SimpleDecoratingHttpClient;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.WebClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.HttpStatusClass;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseableSupport;
import io.opentelemetry.testing.internal.armeria.common.util.TimeoutMode;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.unsafe.PooledObjects;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpHealthChecker
implements AsyncCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HttpHealthChecker.class);
    private static final AsciiString ARMERIA_LPHC = HttpHeaderNames.of("armeria-lphc");
    private final ReentrantLock lock = new ReentrantShortLock();
    private final HealthCheckerContext ctx;
    private final WebClient webClient;
    private final String authority;
    private final String path;
    private final boolean useGet;
    private boolean wasHealthy;
    private int maxLongPollingSeconds;
    private int pingIntervalSeconds;
    @Nullable
    private HttpResponse lastResponse;
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);

    HttpHealthChecker(HealthCheckerContext ctx, String path, boolean useGet) {
        Endpoint endpoint = ctx.endpoint();
        this.ctx = ctx;
        this.webClient = ((WebClientBuilder)WebClient.builder(ctx.protocol(), (EndpointGroup)endpoint).options(ctx.clientOptions()).decorator(x$0 -> new ResponseTimeoutUpdater((HttpClient)x$0))).build();
        this.authority = endpoint.authority();
        this.path = path;
        this.useGet = useGet;
    }

    void start() {
        this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        this.lock();
        try {
            if (this.closeable.isClosing()) {
                return;
            }
            RequestHeadersBuilder builder = RequestHeaders.builder(this.useGet ? HttpMethod.GET : HttpMethod.HEAD, this.path).authority(this.authority);
            RequestHeaders headers = this.maxLongPollingSeconds > 0 ? builder.add((CharSequence)HttpHeaderNames.IF_NONE_MATCH, this.wasHealthy ? "\"healthy\"" : "\"unhealthy\"").add((CharSequence)HttpHeaderNames.PREFER, "wait=" + this.maxLongPollingSeconds).build() : builder.build();
            try (ClientRequestContextCaptor reqCtxCaptor = Clients.newContextCaptor();){
                this.lastResponse = this.webClient.execute(headers);
                ClientRequestContext reqCtx = reqCtxCaptor.get();
                this.lastResponse.subscribe(new HealthCheckResponseSubscriber(reqCtx, this.lastResponse), reqCtx.eventLoop().withoutContext(), SubscriptionOption.WITH_POOLED_OBJECTS);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private synchronized void closeAsync(CompletableFuture<?> future) {
        this.lock();
        try {
            if (this.lastResponse == null) {
                future.complete(null);
            } else {
                this.lastResponse.abort();
                this.lastResponse.whenComplete().handle((unused1, unused2) -> future.complete(null));
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void close() {
        this.closeable.close();
    }

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    private class HealthCheckResponseSubscriber
    implements Subscriber<HttpObject> {
        private final ClientRequestContext reqCtx;
        private final HttpResponse res;
        private Subscription subscription;
        @Nullable
        private ResponseHeaders responseHeaders;
        private boolean isHealthy;
        private boolean receivedExpectedResponse;
        private boolean updatedHealth;
        @Nullable
        private ScheduledFuture<?> pingCheckFuture;
        private long lastPingTimeNanos;

        HealthCheckResponseSubscriber(ClientRequestContext reqCtx, HttpResponse res) {
            this.reqCtx = reqCtx;
            this.res = res;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
            this.maybeSchedulePingCheck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onNext(HttpObject obj) {
            if (HttpHealthChecker.this.closeable.isClosing()) {
                this.subscription.cancel();
                return;
            }
            try {
                ResponseHeaders headers;
                if (!(obj instanceof ResponseHeaders)) {
                    PooledObjects.close(obj);
                    return;
                }
                this.responseHeaders = headers = (ResponseHeaders)obj;
                this.updateLongPollingSettings(headers);
                HttpStatus status = headers.status();
                HttpStatusClass statusClass = status.codeClass();
                switch (statusClass) {
                    case INFORMATIONAL: {
                        this.maybeSchedulePingCheck();
                        return;
                    }
                    case SERVER_ERROR: {
                        this.receivedExpectedResponse = true;
                        return;
                    }
                    case SUCCESS: {
                        this.isHealthy = true;
                        this.receivedExpectedResponse = true;
                        return;
                    }
                    default: {
                        if (status == HttpStatus.NOT_MODIFIED) {
                            this.isHealthy = HttpHealthChecker.this.wasHealthy;
                            this.receivedExpectedResponse = true;
                            return;
                        } else {
                            HttpHealthChecker.this.maxLongPollingSeconds = 0;
                            if (statusClass == HttpStatusClass.CLIENT_ERROR) {
                                logger.warn("{} Unexpected 4xx health check response: {} A 4xx response generally indicates a misconfiguration of the client. Did you happen to forget to configure the {}'s client options?", new Object[]{this.reqCtx, headers, HealthCheckedEndpointGroup.class.getSimpleName()});
                                return;
                            } else {
                                logger.warn("{} Unexpected health check response: {}", (Object)this.reqCtx, (Object)headers);
                            }
                        }
                        return;
                    }
                }
            }
            finally {
                this.subscription.request(1L);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.updateHealth(t);
        }

        @Override
        public void onComplete() {
            this.updateHealth(null);
        }

        private void updateLongPollingSettings(ResponseHeaders headers) {
            String longPollingSettings = headers.get(ARMERIA_LPHC);
            if (longPollingSettings == null) {
                HttpHealthChecker.this.maxLongPollingSeconds = 0;
                HttpHealthChecker.this.pingIntervalSeconds = 0;
                return;
            }
            int commaPos = longPollingSettings.indexOf(44);
            int maxLongPollingSeconds = 0;
            int pingIntervalSeconds = 0;
            try {
                maxLongPollingSeconds = Integer.max(0, Integer.parseInt(longPollingSettings.substring(0, commaPos).trim()));
                pingIntervalSeconds = Integer.max(0, Integer.parseInt(longPollingSettings.substring(commaPos + 1).trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            HttpHealthChecker.this.maxLongPollingSeconds = maxLongPollingSeconds;
            if (maxLongPollingSeconds > 0 && pingIntervalSeconds < maxLongPollingSeconds) {
                HttpHealthChecker.this.pingIntervalSeconds = pingIntervalSeconds;
            } else {
                HttpHealthChecker.this.pingIntervalSeconds = 0;
            }
        }

        private void maybeSchedulePingCheck() {
            this.lastPingTimeNanos = System.nanoTime();
            if (this.pingCheckFuture != null) {
                return;
            }
            int pingIntervalSeconds = HttpHealthChecker.this.pingIntervalSeconds;
            if (pingIntervalSeconds <= 0) {
                return;
            }
            long pingTimeoutNanos = TimeUnit.SECONDS.toNanos(pingIntervalSeconds) * 2L;
            this.pingCheckFuture = this.reqCtx.eventLoop().withoutContext().scheduleWithFixedDelay(() -> {
                if (System.nanoTime() - this.lastPingTimeNanos >= pingTimeoutNanos) {
                    ResponseTimeoutException cause = ResponseTimeoutException.get();
                    this.res.abort(cause);
                    this.isHealthy = false;
                    this.receivedExpectedResponse = false;
                    this.updateHealth(cause);
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }

        private void updateHealth(@Nullable Throwable cause) {
            if (this.pingCheckFuture != null) {
                this.pingCheckFuture.cancel(false);
            }
            if (HttpHealthChecker.this.closeable.isClosing() || this.updatedHealth) {
                return;
            }
            this.updatedHealth = true;
            HttpHealthChecker.this.ctx.updateHealth(this.isHealthy ? 1.0 : 0.0, this.reqCtx, this.responseHeaders, cause);
            HttpHealthChecker.this.wasHealthy = this.isHealthy;
            ScheduledExecutorService executor = HttpHealthChecker.this.ctx.executor();
            try {
                if (HttpHealthChecker.this.maxLongPollingSeconds > 0 && this.receivedExpectedResponse) {
                    executor.execute(() -> HttpHealthChecker.this.check());
                } else {
                    executor.schedule(() -> HttpHealthChecker.this.check(), HttpHealthChecker.this.ctx.nextDelayMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private final class ResponseTimeoutUpdater
    extends SimpleDecoratingHttpClient {
        ResponseTimeoutUpdater(HttpClient delegate) {
            super(delegate);
        }

        @Override
        public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
            if (HttpHealthChecker.this.maxLongPollingSeconds > 0) {
                ctx.setResponseTimeoutMillis(TimeoutMode.EXTEND, TimeUnit.SECONDS.toMillis(HttpHealthChecker.this.maxLongPollingSeconds));
            }
            return (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
        }
    }
}

