/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.limit;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.limit.ConcurrencyLimit;
import io.opentelemetry.testing.internal.armeria.client.limit.ConcurrencyLimitBuilder;
import io.opentelemetry.testing.internal.armeria.client.limit.ConcurrencyLimitTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.limit.TooManyPendingAcquisitionsException;
import io.opentelemetry.testing.internal.armeria.common.ContextAwareEventLoop;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultConcurrencyLimit
implements ConcurrencyLimit {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConcurrencyLimit.class);
    private final Predicate<? super ClientRequestContext> predicate;
    private final IntSupplier maxConcurrency;
    private final int maxPendingAcquisitions;
    private final long timeoutMillis;
    private final Queue<PendingAcquisition> pendingAcquisitions = new ConcurrentLinkedQueue<PendingAcquisition>();
    private final AtomicLong numPendingAcquisitions = new AtomicLong();
    private final AtomicInteger acquiredPermits = new AtomicInteger();

    DefaultConcurrencyLimit(Predicate<? super ClientRequestContext> predicate, IntSupplier maxConcurrency, int maxPendingAcquisitions, long timeoutMillis) {
        this.predicate = predicate;
        this.maxConcurrency = maxConcurrency;
        this.maxPendingAcquisitions = maxPendingAcquisitions;
        this.timeoutMillis = timeoutMillis;
    }

    int acquiredPermits() {
        return this.acquiredPermits.get();
    }

    int availablePermits() {
        int availablePermitCount = this.maxConcurrency() - this.acquiredPermits.get();
        return Math.max(availablePermitCount, 0);
    }

    int maxConcurrency() {
        int maxConcurrency = this.maxConcurrency.getAsInt();
        if (maxConcurrency < 0) {
            logger.warn("maxConcurrency.get() returned {}; maxConcurrency is set to 0.", (Object)maxConcurrency);
            return 0;
        }
        return maxConcurrency;
    }

    @Override
    public CompletableFuture<SafeCloseable> acquire(ClientRequestContext ctx) {
        if (!this.predicate.test(ctx)) {
            return ConcurrencyLimitBuilder.noLimitFuture;
        }
        if (this.pendingAcquisitions.isEmpty()) {
            if (this.acquiredPermits.incrementAndGet() <= this.maxConcurrency()) {
                return UnmodifiableFuture.completedFuture(new Permit());
            }
            this.acquiredPermits.decrementAndGet();
        }
        if (this.maxPendingAcquisitions == 0) {
            return UnmodifiableFuture.exceptionallyCompletedFuture(TooManyPendingAcquisitionsException.get());
        }
        if (this.numPendingAcquisitions.incrementAndGet() > (long)this.maxPendingAcquisitions) {
            this.numPendingAcquisitions.decrementAndGet();
            return UnmodifiableFuture.exceptionallyCompletedFuture(TooManyPendingAcquisitionsException.get());
        }
        CompletableFuture<SafeCloseable> future = new CompletableFuture<SafeCloseable>();
        PendingAcquisition pendingAcquisition = new PendingAcquisition(ctx, future);
        this.pendingAcquisitions.add(pendingAcquisition);
        this.drain();
        return future;
    }

    void drain() {
        int currentAcquiredPermits;
        while (!this.pendingAcquisitions.isEmpty() && (currentAcquiredPermits = this.acquiredPermits.get()) < this.maxConcurrency()) {
            if (!this.acquiredPermits.compareAndSet(currentAcquiredPermits, currentAcquiredPermits + 1)) continue;
            PendingAcquisition task = this.pendingAcquisitions.poll();
            if (task == null) {
                this.acquiredPermits.decrementAndGet();
                if (this.pendingAcquisitions.isEmpty()) break;
                continue;
            }
            task.run();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxConcurrency", this.maxConcurrency).add("maxPendingAcquisitions", this.maxPendingAcquisitions).add("acquiredPermits", this.acquiredPermits).add("timeoutMillis", this.timeoutMillis).toString();
    }

    private class Permit
    implements SafeCloseable {
        private boolean closed;

        private Permit() {
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            DefaultConcurrencyLimit.this.acquiredPermits.decrementAndGet();
            DefaultConcurrencyLimit.this.drain();
        }
    }

    private final class PendingAcquisition
    implements Runnable {
        private final ClientRequestContext ctx;
        private final CompletableFuture<SafeCloseable> future;
        @Nullable
        private final ScheduledFuture<?> timeoutFuture;

        PendingAcquisition(ClientRequestContext ctx, CompletableFuture<SafeCloseable> future) {
            this.ctx = ctx;
            this.future = future;
            this.timeoutFuture = DefaultConcurrencyLimit.this.timeoutMillis != 0L ? ctx.eventLoop().withoutContext().schedule(() -> {
                future.completeExceptionally(ConcurrencyLimitTimeoutException.get());
                DefaultConcurrencyLimit.this.numPendingAcquisitions.decrementAndGet();
            }, DefaultConcurrencyLimit.this.timeoutMillis, TimeUnit.MILLISECONDS) : null;
        }

        @Override
        public void run() {
            if (this.timeoutFuture != null && (this.timeoutFuture.isDone() || !this.timeoutFuture.cancel(false))) {
                DefaultConcurrencyLimit.this.acquiredPermits.decrementAndGet();
                return;
            }
            DefaultConcurrencyLimit.this.numPendingAcquisitions.decrementAndGet();
            ContextAwareEventLoop eventLoop = this.ctx.eventLoop();
            if (eventLoop.inEventLoop()) {
                try (SafeCloseable ignored = this.ctx.replace();){
                    this.completePermit();
                }
            } else {
                eventLoop.execute(this::completePermit);
            }
        }

        private void completePermit() {
            Permit permit = new Permit();
            if (!this.future.complete(permit)) {
                permit.close();
            }
        }
    }
}

