/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.logging;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.SimpleDecoratingClient;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.logging.LogWriter;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.util.Sampler;
import io.opentelemetry.testing.internal.armeria.internal.common.logging.LoggingUtils;
import java.util.Objects;

abstract class AbstractLoggingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private final LogWriter logWriter;
    private final Sampler<? super RequestLog> sampler;

    AbstractLoggingClient(Client<I, O> delegate, LogWriter logWriter, Sampler<? super ClientRequestContext> successSampler, Sampler<? super ClientRequestContext> failureSampler) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.logWriter = Objects.requireNonNull(logWriter, "logWriter");
        Objects.requireNonNull(successSampler, "successSampler");
        Objects.requireNonNull(failureSampler, "failureSampler");
        this.sampler = requestLog -> {
            ClientRequestContext ctx = (ClientRequestContext)requestLog.context();
            if (ctx.options().successFunction().isSuccess(ctx, (RequestLog)requestLog)) {
                return successSampler.isSampled(ctx);
            }
            return failureSampler.isSampled(ctx);
        };
    }

    @Override
    public final O execute(ClientRequestContext ctx, I req) throws Exception {
        ctx.log().whenComplete().thenAccept(log -> {
            if (this.sampler.isSampled((RequestLog)log)) {
                LoggingUtils.log(ctx, log, this.logWriter);
            }
        });
        return ((Client)this.unwrap()).execute(ctx, req);
    }
}

