/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.proxy;

import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyConfig;
import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Objects;

public final class HAProxyConfig
extends ProxyConfig {
    private final InetSocketAddress proxyAddress;
    @Nullable
    private final InetSocketAddress sourceAddress;

    HAProxyConfig(InetSocketAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
        this.sourceAddress = null;
    }

    HAProxyConfig(InetSocketAddress proxyAddress, InetSocketAddress sourceAddress) {
        Preconditions.checkArgument(sourceAddress.getAddress().getClass() == proxyAddress.getAddress().getClass(), "sourceAddress and proxyAddress should be the same type");
        this.proxyAddress = proxyAddress;
        this.sourceAddress = sourceAddress;
    }

    @Override
    public ProxyType proxyType() {
        return ProxyType.HAPROXY;
    }

    @Override
    public InetSocketAddress proxyAddress() {
        return this.proxyAddress;
    }

    @Nullable
    public InetSocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HAProxyConfig)) {
            return false;
        }
        HAProxyConfig that = (HAProxyConfig)o;
        return this.proxyAddress.equals(that.proxyAddress) && Objects.equals(this.sourceAddress, that.sourceAddress);
    }

    public int hashCode() {
        return Objects.hash(this.proxyAddress, this.sourceAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("proxyType", (Object)this.proxyType()).add("proxyAddress", this.proxyAddress).add("sourceAddress", this.sourceAddress).toString();
    }
}

