/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.AbstractRuleWithContentBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryDecision;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRule;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleBuilder;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleUtil;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleWithContent;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.internal.client.AbstractRuleBuilderUtil;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class RetryRuleWithContentBuilder<T extends Response>
extends AbstractRuleWithContentBuilder<RetryRuleWithContentBuilder<T>, T> {
    RetryRuleWithContentBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public RetryRuleWithContent<T> thenBackoff() {
        return this.thenBackoff(Backoff.ofDefault());
    }

    public RetryRuleWithContent<T> thenBackoff(Backoff backoff) {
        Objects.requireNonNull(backoff, "backoff");
        return this.build(RetryDecision.retry(backoff));
    }

    public RetryRuleWithContent<T> thenNoRetry() {
        return this.build(RetryDecision.noRetry());
    }

    RetryRuleWithContent<T> build(RetryDecision decision) {
        boolean hasResponseFilter;
        BiFunction responseFilter = this.responseFilter();
        boolean bl = hasResponseFilter = responseFilter != null;
        if (decision != RetryDecision.noRetry() && this.exceptionFilter() == null && this.responseHeadersFilter() == null && this.responseTrailersFilter() == null && this.grpcTrailersFilter() == null && !hasResponseFilter) {
            throw new IllegalStateException("Should set at least one retry rule if a backoff was set.");
        }
        BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter = AbstractRuleBuilderUtil.buildFilter(this.requestHeadersFilter(), this.responseHeadersFilter(), this.responseTrailersFilter(), this.grpcTrailersFilter(), this.exceptionFilter(), this.totalDurationFilter(), hasResponseFilter);
        RetryRule first = RetryRuleBuilder.build(ruleFilter, decision, this.requiresResponseTrailers());
        if (!hasResponseFilter) {
            return RetryRuleUtil.fromRetryRule(first);
        }
        RetryRuleWithContent<Response> second = (ctx, content, cause) -> {
            if (content == null) {
                return RetryRuleUtil.NEXT_DECISION;
            }
            return ((CompletionStage)responseFilter.apply(ctx, content)).handle((matched, cause0) -> {
                if (cause0 != null) {
                    return RetryDecision.next();
                }
                return matched != false ? decision : RetryDecision.next();
            });
        };
        return RetryRuleUtil.orElse(first, second);
    }
}

