/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.websocket;

import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.websocket.DefaultWebSocketClient;
import io.opentelemetry.testing.internal.armeria.client.websocket.WebSocketClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.websocket.WebSocketSession;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.Unwrappable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@UnstableApi
public interface WebSocketClient
extends ClientBuilderParams,
Unwrappable {
    public static WebSocketClient of() {
        return DefaultWebSocketClient.DEFAULT;
    }

    public static WebSocketClient of(String uri) {
        return WebSocketClient.builder(uri).build();
    }

    public static WebSocketClient of(URI uri) {
        return WebSocketClient.builder(uri).build();
    }

    public static WebSocketClient of(String scheme, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(scheme, endpointGroup).build();
    }

    public static WebSocketClient of(Scheme scheme, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(scheme, endpointGroup).build();
    }

    public static WebSocketClient of(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(protocol, endpointGroup).build();
    }

    public static WebSocketClient of(String scheme, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(scheme, endpointGroup, path).build();
    }

    public static WebSocketClient of(Scheme scheme, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(scheme, endpointGroup, path).build();
    }

    public static WebSocketClient of(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(protocol, endpointGroup, path).build();
    }

    public static WebSocketClientBuilder builder() {
        return WebSocketClient.builder(ClientUtil.UNDEFINED_URI);
    }

    public static WebSocketClientBuilder builder(String uri) {
        return WebSocketClient.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static WebSocketClientBuilder builder(URI uri) {
        return new WebSocketClientBuilder(Objects.requireNonNull(uri, "uri"));
    }

    public static WebSocketClientBuilder builder(String scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        return WebSocketClient.builder(Scheme.parse(scheme), endpointGroup);
    }

    public static WebSocketClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new WebSocketClientBuilder(scheme, endpointGroup, null);
    }

    public static WebSocketClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        Objects.requireNonNull(protocol, "protocol");
        return WebSocketClient.builder(Scheme.of(SerializationFormat.WS, protocol), endpointGroup);
    }

    public static WebSocketClientBuilder builder(String scheme, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(scheme, "scheme");
        return WebSocketClient.builder(Scheme.parse(scheme), endpointGroup, path);
    }

    public static WebSocketClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new WebSocketClientBuilder(scheme, endpointGroup, path);
    }

    public static WebSocketClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        return WebSocketClient.builder(Scheme.of(SerializationFormat.WS, protocol), endpointGroup, path);
    }

    default public CompletableFuture<WebSocketSession> connect(String path) {
        return this.connect(path, HttpHeaders.of());
    }

    default public CompletableFuture<WebSocketSession> connect(String path, HttpHeaders headers) {
        return this.connect(path, headers, RequestOptions.of());
    }

    public CompletableFuture<WebSocketSession> connect(String var1, HttpHeaders var2, RequestOptions var3);

    @Override
    public WebClient unwrap();
}

