/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.internal.common.ByteArrayBytes;
import java.util.Arrays;

final class ByteArrayHttpData
extends ByteArrayBytes
implements HttpData {
    private static final byte[] EMPTY_BYTES = new byte[0];
    static final ByteArrayHttpData EMPTY = new ByteArrayHttpData(EMPTY_BYTES);
    static final ByteArrayHttpData EMPTY_EOS = new ByteArrayHttpData(EMPTY_BYTES, true);
    private final boolean endOfStream;

    ByteArrayHttpData(byte[] array) {
        super(array);
        this.endOfStream = false;
    }

    private ByteArrayHttpData(byte[] array, boolean endOfStream) {
        super(array);
        this.endOfStream = endOfStream;
    }

    @Override
    public HttpData withEndOfStream(boolean endOfStream) {
        if (this.endOfStream == endOfStream) {
            return this;
        }
        if (this.isEmpty()) {
            return endOfStream ? EMPTY_EOS : EMPTY;
        }
        return new ByteArrayHttpData(this.array(), endOfStream);
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpData)) {
            return false;
        }
        HttpData that = (HttpData)o;
        if (this.length() != that.length()) {
            return false;
        }
        return Arrays.equals(this.array(), that.array());
    }

    @Override
    public String toString() {
        String toString = super.toString();
        if (!this.isEndOfStream()) {
            return toString;
        }
        return toString + ", {EOS}";
    }
}

