/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.CacheControl;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;

abstract class CacheControlBuilder {
    private boolean noCache;
    private boolean noStore;
    private boolean noTransform;
    private long maxAgeSeconds = -1L;

    CacheControlBuilder() {
    }

    CacheControlBuilder(CacheControl c) {
        this.noCache = c.noCache();
        this.noStore = c.noStore();
        this.noTransform = c.noTransform();
        this.maxAgeSeconds = c.maxAgeSeconds();
    }

    public CacheControlBuilder noCache() {
        return this.noCache(true);
    }

    public CacheControlBuilder noCache(boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    public CacheControlBuilder noStore() {
        return this.noStore(true);
    }

    public CacheControlBuilder noStore(boolean noStore) {
        this.noStore = noStore;
        return this;
    }

    public CacheControlBuilder noTransform() {
        return this.noTransform(true);
    }

    public CacheControlBuilder noTransform(boolean noTransform) {
        this.noTransform = noTransform;
        return this;
    }

    public CacheControlBuilder maxAge(@Nullable Duration maxAge) {
        this.maxAgeSeconds = CacheControlBuilder.validateDuration(maxAge, "maxAge");
        return this;
    }

    static long validateDuration(@Nullable Duration value, String name) {
        if (value == null) {
            return -1L;
        }
        Preconditions.checkArgument(!value.isNegative(), "%s: %s (expected: >= 0)", (Object)name, (Object)value);
        return value.getSeconds();
    }

    public CacheControlBuilder maxAgeSeconds(long maxAgeSeconds) {
        this.maxAgeSeconds = CacheControlBuilder.validateSeconds(maxAgeSeconds, "maxAgeSeconds");
        return this;
    }

    static long validateSeconds(long value, String name) {
        Preconditions.checkArgument(value >= 0L, "%s: %s (expected: >= 0)", (Object)name, value);
        return value;
    }

    public CacheControl build() {
        return this.build(this.noCache, this.noStore, this.noTransform, this.maxAgeSeconds);
    }

    abstract CacheControl build(boolean var1, boolean var2, boolean var3, long var4);
}

