/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareScheduledExecutorService;
import io.opentelemetry.testing.internal.armeria.common.DefaultContextAwareBlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.BlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import java.util.Objects;

public interface ContextAwareBlockingTaskExecutor
extends ContextAwareScheduledExecutorService,
BlockingTaskExecutor {
    public static ContextAwareBlockingTaskExecutor of(RequestContext context, BlockingTaskExecutor executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareBlockingTaskExecutor) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareBlockingTaskExecutor)executor, ContextAwareBlockingTaskExecutor.class);
            return (ContextAwareBlockingTaskExecutor)executor;
        }
        return new DefaultContextAwareBlockingTaskExecutor(context, executor);
    }

    @Override
    public RequestContext context();

    @Override
    public BlockingTaskExecutor withoutContext();
}

